<?php
/**
 * Background RESY-Import
 * Lädt Daten im Hintergrund und speichert in DB
 */

require_once dirname(__DIR__) . '/config/database.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

try {
    $autohausId = $_GET['autohaus_id'] ?? $_POST['autohaus_id'] ?? 1;
    
    // Lade Playwright-Daten
    $script = dirname(__DIR__) . '/resy_playwright.js';
    $command = "node \"$script\" 2>&1";
    
    error_log("🔄 Background RESY-Import für Autohaus {$autohausId}...");
    set_time_limit(300);
    
    $startTime = microtime(true);
    $output = shell_exec($command);
    $duration = round(microtime(true) - $startTime, 2);
    
    // Parse JSON
    $lines = explode("\n", $output);
    $result = null;
    foreach ($lines as $line) {
        if (strpos($line, '{"success":') !== false) {
            $result = json_decode($line, true);
            break;
        }
    }
    
    if (!$result || !$result['success']) {
        echo json_encode([
            'success' => false,
            'error' => 'Keine Daten von Playwright erhalten',
            'count' => 0
        ]);
        exit;
    }
    
    // Speichere in Datenbank
    $db = new Database();
    $pdo = $db->getConnection();
    
    // Lösche alte Daten aus v2 Tabelle
    $stmt = $pdo->prepare("DELETE FROM stored_wheelsets_v2 WHERE autohaus_id = ?");
    $stmt->execute([$autohausId]);
    
    // Speichere nur eindeutige Kennzeichen
    $seen = [];
    $count = 0;
    
    foreach ($result['wheelsets'] as $ws) {
        $kennzeichen = trim($ws['kennzeichen'] ?? '');
        
        if (empty($kennzeichen) || isset($seen[$kennzeichen])) {
            continue;
        }
        
        $seen[$kennzeichen] = true;
        
        try {
            $stmt = $pdo->prepare("
                INSERT INTO stored_wheelsets_v2 
                (autohaus_id, satznummer, haltername, kennzeichen, fin, autohaus, ziel_autohaus, 
                 eingangsdatum, rueckliefertermin, pruefbericht, reifenmodell, reifenart, saison, 
                 reifengroesse, lagerplatz, profiltiefe, empfehlung, rueckgabe_bemerkung, status, created_at, updated_at)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'gelagert', NOW(), NOW())
            ");
            
            $stmt->execute([
                $autohausId,
                $ws['satznummer'] ?? '',
                $ws['haltername'] ?? '',
                $kennzeichen,
                $ws['fin'] ?? '',
                $ws['autohaus'] ?? '',
                $ws['ziel_autohaus'] ?? '',
                $ws['eingangsdatum'] ?? '',
                $ws['rueckliefertermin'] ?? '',
                $ws['pruefbericht'] ?? '',
                $ws['reifenmodell'] ?? '',
                $ws['reifenart'] ?? '',
                $ws['saison'] ?? '',
                $ws['reifengroesse'] ?? '',
                $ws['lagerplatz'] ?? '',
                $ws['profiltiefe'] ?? '',
                $ws['empfehlung'] ?? '',
                $ws['rueckgabe_bemerkung'] ?? ''
            ]);
            
            $count++;
        } catch (Exception $e) {
            error_log("Fehler beim Speichern von {$kennzeichen} (v2): " . $e->getMessage());
        }
    }
    
    error_log("✅ {$count} Reifensätze im Hintergrund importiert ({$duration}s)");
    
    echo json_encode([
        'success' => true,
        'count' => $count,
        'duration' => $duration,
        'expected' => isset($result['expected']) ? $result['expected'] : 0
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'count' => 0
    ]);
}

