<?php
/**
 * Activity Log für Benutzer abrufen
 */

session_start();

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Prüfe ob User eingeloggt ist
if (!isset($_SESSION['user_logged_in']) || !$_SESSION['user_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

require_once __DIR__ . '/../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $user_id = $_SESSION['user_id'];
    $limit = intval($_GET['limit'] ?? 20);
    $offset = intval($_GET['offset'] ?? 0);
    
    // Activity Log laden
    $stmt = $conn->prepare("
        SELECT * FROM user_activity_log 
        WHERE user_id = ? 
        ORDER BY created_at DESC 
        LIMIT ? OFFSET ?
    ");
    $stmt->execute([$user_id, $limit, $offset]);
    $activities = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Gesamtanzahl
    $stmt = $conn->prepare("SELECT COUNT(*) FROM user_activity_log WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $total_count = $stmt->fetchColumn();
    
    // Statistiken nach Action Type
    $stmt = $conn->prepare("
        SELECT action_type, COUNT(*) as count 
        FROM user_activity_log 
        WHERE user_id = ? 
        GROUP BY action_type 
        ORDER BY count DESC
    ");
    $stmt->execute([$user_id]);
    $stats = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'activities' => $activities,
        'total_count' => $total_count,
        'stats' => $stats,
        'limit' => $limit,
        'offset' => $offset
    ]);
    
} catch (\Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

