<?php
/**
 * Clear RESY Session Cookies
 * Hilft beim Debugging von Session-Problemen
 */

require_once __DIR__ . '/../config/database.php';

// Hole alle Autohaus-Daten
$db = new Database();
$conn = $db->getConnection();

$stmt = $conn->prepare("SELECT id, name, resy_base_url FROM autohaus WHERE resy_base_url IS NOT NULL");
$stmt->execute();
$autohausList = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<h2>RESY Session-Cookies löschen</h2>";

foreach ($autohausList as $autohaus) {
    $cookieFile = sys_get_temp_dir() . '/resy_cookies_breakthrough.txt';
    
    echo "<h3>Autohaus: " . htmlspecialchars($autohaus['name']) . "</h3>";
    echo "<p>URL: " . htmlspecialchars($autohaus['resy_base_url']) . "</p>";
    
    if (file_exists($cookieFile)) {
        $fileSize = filesize($cookieFile);
        $fileTime = date('Y-m-d H:i:s', filemtime($cookieFile));
        $age = time() - filemtime($cookieFile);
        
        echo "<p>Cookie-Datei existiert:</p>";
        echo "<ul>";
        echo "<li>Größe: " . $fileSize . " Bytes</li>";
        echo "<li>Erstellt: " . $fileTime . "</li>";
        echo "<li>Alter: " . $age . " Sekunden (" . round($age/60) . " Minuten)</li>";
        echo "</ul>";
        
        if (isset($_GET['clear']) && $_GET['clear'] == $autohaus['id']) {
            if (unlink($cookieFile)) {
                echo "<p style='color: green;'>✅ Cookie-Datei erfolgreich gelöscht!</p>";
            } else {
                echo "<p style='color: red;'>❌ Fehler beim Löschen der Cookie-Datei</p>";
            }
        } else {
            echo "<a href='?clear=" . $autohaus['id'] . "' style='background: #dc3545; color: white; padding: 5px 10px; text-decoration: none; border-radius: 3px;'>Cookie löschen</a>";
        }
    } else {
        echo "<p style='color: orange;'>⚠️ Keine Cookie-Datei gefunden</p>";
    }
    
    echo "<hr>";
}

echo "<h3>Alle Cookies löschen</h3>";
if (isset($_GET['clear_all'])) {
    $cookieFile = sys_get_temp_dir() . '/resy_cookies_breakthrough.txt';
    if (file_exists($cookieFile)) {
        unlink($cookieFile);
        echo "<p style='color: green;'>✅ Alle Cookie-Dateien gelöscht!</p>";
    } else {
        echo "<p style='color: orange;'>⚠️ Keine Cookie-Dateien gefunden</p>";
    }
} else {
    echo "<a href='?clear_all=1' style='background: #dc3545; color: white; padding: 5px 10px; text-decoration: none; border-radius: 3px;'>Alle Cookies löschen</a>";
}

echo "<hr>";
echo "<p><a href='../admin/appointments.php' style='background: #007bff; color: white; padding: 5px 10px; text-decoration: none; border-radius: 3px;'>Zurück zu Appointments</a></p>";
?>
