<?php
/**
 * Termin stornieren
 */

session_start();

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Prüfe ob User eingeloggt ist
if (!isset($_SESSION['user_logged_in']) || !$_SESSION['user_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

require_once __DIR__ . '/../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['appointment_id'])) {
        throw new Exception('Appointment ID ist erforderlich');
    }
    
    $appointment_id = intval($input['appointment_id']);
    $user_id = $_SESSION['user_id'];
    
    // Prüfe ob Termin dem User gehört
    $stmt = $conn->prepare("SELECT * FROM appointments WHERE id = ? AND user_id = ?");
    $stmt->execute([$appointment_id, $user_id]);
    $appointment = $stmt->fetch();
    
    if (!$appointment) {
        throw new Exception('Termin nicht gefunden oder nicht autorisiert');
    }
    
    // Prüfe ob Termin bereits storniert oder in der Vergangenheit liegt
    $stmt = $conn->prepare("
        SELECT e.event_date, e.event_time, e.start_time 
        FROM appointments a 
        JOIN events e ON a.event_id = e.id 
        WHERE a.id = ?
    ");
    $stmt->execute([$appointment_id]);
    $event = $stmt->fetch();
    
    if (!$event) {
        throw new Exception('Event nicht gefunden');
    }
    
    $event_time = $event['event_time'] ?? $event['start_time'];
    $appointment_datetime = strtotime($event['event_date'] . ' ' . $event_time);
    
    if ($appointment_datetime < time()) {
        throw new Exception('Termine in der Vergangenheit können nicht storniert werden');
    }
    
    // Termin stornieren
    $stmt = $conn->prepare("UPDATE appointments SET is_active = 0, status = 'cancelled' WHERE id = ?");
    $result = $stmt->execute([$appointment_id]);
    
    if (!$result) {
        throw new Exception('Fehler beim Stornieren');
    }
    
    // Activity Log Eintrag
    $stmt = $conn->prepare("
        INSERT INTO user_activity_log (user_id, action_type, description)
        VALUES (?, 'appointment_cancelled', ?)
    ");
    $description = "Termin storniert für " . ($appointment['license_plate'] ?? 'unbekanntes Fahrzeug');
    $stmt->execute([$user_id, $description]);
    
    // Benachrichtigung erstellen mit Push
    require_once __DIR__ . '/../includes/push_notification_helper.php';
    $result = createNotificationWithPush(
        $conn,
        $user_id,
        'Termin storniert',
        'Ihr Termin wurde erfolgreich storniert.',
        'info',
        '/profile.php'
    );
    
    echo json_encode([
        'success' => true,
        'message' => 'Termin erfolgreich storniert'
    ]);
    
} catch (\Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

