<?php
/**
 * User ablehnen
 */

// Error reporting für Debugging
error_reporting(E_ALL);
ini_set('display_errors', 0); // WICHTIG: Fehler nicht ausgeben!
ini_set('log_errors', 1);

session_start();

// Prüfe ob Admin eingeloggt ist
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    http_response_code(401);
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

require_once __DIR__ . '/config.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || empty($input['user_id'])) {
        throw new Exception('User-ID erforderlich');
    }
    
    if (empty($input['reason'])) {
        throw new Exception('Grund erforderlich');
    }
    
    $user_id = $input['user_id'];
    $reason = $input['reason'];
    $admin_id = $_SESSION['admin_user_id'] ?? 0;
    
    // User ablehnen - setze sowohl verification_status als auch status
    $stmt = $pdo->prepare("UPDATE users SET verification_status = 'rejected', status = 'rejected', verification_reason = ?, verified_by = ?, verified_at = NOW() WHERE id = ?");
    $result = $stmt->execute([$reason, $admin_id, $user_id]);
    
    if ($result) {
        // Push-Benachrichtigung senden
        require_once __DIR__ . '/../includes/notification_triggers.php';
        sendNotificationForTrigger('verification_rejected', $user_id, ['reason' => $reason]);
        // User-Daten für E-Mail laden
        $stmt = $pdo->prepare("SELECT email, first_name, last_name FROM users WHERE id = ?");
        $stmt->execute([$user_id]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // E-Mail-Benachrichtigung senden
        if ($user) {
            $to = $user['email'];
            $subject = "Ihr Antrag wurde abgelehnt - B&E Gruppe";
            $message = "
                <!DOCTYPE html>
                <html>
                <head>
                    <meta charset='UTF-8'>
                    <style>
                        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                        .header { background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
                        .content { background: #f8f9fa; padding: 30px; border-radius: 0 0 10px 10px; }
                        .reason-box { background: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0; border-radius: 8px; }
                        .button { display: inline-block; background: #0056b3; color: white; padding: 15px 30px; text-decoration: none; border-radius: 8px; margin: 20px 0; }
                        .footer { text-align: center; color: #6c757d; font-size: 12px; margin-top: 30px; }
                    </style>
                </head>
                <body>
                    <div class='container'>
                        <div class='header'>
                            <h1>❌ Ihr Antrag wurde abgelehnt</h1>
                        </div>
                        <div class='content'>
                            <h2>Hallo {$user['first_name']} {$user['last_name']},</h2>
                            <p>leider müssen wir Ihnen mitteilen, dass Ihr Verifikationsantrag abgelehnt wurde.</p>
                            
                            <div class='reason-box'>
                                <strong>📋 Ablehnungsgrund:</strong>
                                <p>" . htmlspecialchars($reason) . "</p>
                            </div>
                            
                            <p><strong>Was können Sie tun?</strong></p>
                            <ul>
                                <li>📄 Überprüfen Sie Ihr Dokument</li>
                                <li>📤 Laden Sie ein neues Verifikationsdokument hoch</li>
                                <li>📞 Kontaktieren Sie uns bei Fragen</li>
                            </ul>
                            
                            <p style='text-align: center;'>
                                <a href='https://be-automobileapps.de/profile.php' class='button'>Neues Dokument hochladen</a>
                            </p>
                            
                            <p><strong>Wir stehen Ihnen gerne zur Verfügung!</strong></p>
                        </div>
                        <div class='footer'>
                            <p>B&E Gruppe - Ihr Service-Partner</p>
                            <p>Diese E-Mail wurde automatisch generiert.</p>
                        </div>
                    </div>
                </body>
                </html>
            ";
            
            // SMTP-Einstellungen aus dem ersten aktiven Autohaus laden
            $stmt = $pdo->prepare("SELECT email_smtp_host, email_smtp_port, email_smtp_username, email_smtp_password, email_smtp_encryption, email_from_name, name FROM autohaus WHERE is_active = 1 AND email_smtp_host IS NOT NULL AND email_smtp_host != '' ORDER BY id LIMIT 1");
            $stmt->execute();
            $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
            
            // PHPMailer verwenden falls verfügbar
            if ($autohaus && !empty($autohaus['email_smtp_host']) && !empty($autohaus['email_smtp_password'])) {
                // Verwende vendor-Version (richtige PHPMailer-Implementierung mit Office 365 Fix)
                if (file_exists(__DIR__ . '/../vendor/phpmailer/PHPMailer.php')) {
                    require_once __DIR__ . '/../vendor/phpmailer/PHPMailer.php';
                    require_once __DIR__ . '/../vendor/phpmailer/SMTP.php';
                    require_once __DIR__ . '/../vendor/phpmailer/Exception.php';
                } else {
                    require_once __DIR__ . '/phpmailer/PHPMailer.php';
                    require_once __DIR__ . '/phpmailer/SMTP.php';
                    require_once __DIR__ . '/phpmailer/Exception.php';
                }
                
                // PHPMailer instanziieren - prüfe Namespace
                $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
                try {
                    // SMTP-Konfiguration aus Autohaus-Daten
                    $mail->isSMTP();
                    $mail->Host = $autohaus['email_smtp_host'];
                    $mail->SMTPAuth = true;
                    $mail->Username = $autohaus['email_smtp_username'];
                    $mail->Password = $autohaus['email_smtp_password'];
                    $mail->SMTPSecure = \PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
                    $mail->Port = 587;
                    $mail->CharSet = 'UTF-8';
                    $mail->SMTPDebug = 0;
                    
                    // Empfänger
                    $mail->setFrom($autohaus['email_smtp_username'], $autohaus['email_from_name'] ?? 'B&E Gruppe');
                    $mail->addAddress($to, $user['first_name'] . ' ' . $user['last_name']);
                    
                    // E-Mail-Inhalt
                    $mail->isHTML(true);
                    $mail->Subject = $subject;
                    $mail->Body = $message;
                    
                    $mail->send();
                    error_log("=== ABLEHNUNGS-E-MAIL ERFOLGREICH ===");
                    error_log("Empfänger: $to");
                    error_log("Autohaus: " . $autohaus['name']);
                    error_log("Betreff: $subject");
                    error_log("SMTP Server: " . $autohaus['email_smtp_host'] . ":" . $autohaus['email_smtp_port']);
                } catch (\Exception $e) {
                    error_log("=== ABLEHNUNGS-E-MAIL FEHLER ===");
                    error_log("Empfänger: $to");
                    error_log("Autohaus: " . $autohaus['name']);
                    error_log("Fehler: " . $e->getMessage());
                    error_log("SMTP Server: " . $autohaus['email_smtp_host'] . ":" . $autohaus['email_smtp_port']);
                    error_log("Username: " . $autohaus['email_smtp_username']);
                    if (isset($debugOutput)) {
                        error_log("SMTP Debug Output:\n" . $debugOutput);
                    }
                }
            } else {
                // Fallback: PHP mail() Funktion
                $headers = "MIME-Version: 1.0" . "\r\n";
                $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
                $headers .= "From: B&E Gruppe <noreply@be-automobileapps.de>" . "\r\n";
                
                @mail($to, $subject, $message, $headers);
                error_log("Fallback: Ablehnungs-E-Mail versendet an: " . $to);
            }
        }
        
        echo json_encode([
            'success' => true,
            'message' => 'User abgelehnt'
        ]);
    } else {
        throw new Exception('Fehler beim Ablehnen');
    }
    
} catch (\Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

