<?php
/**
 * Fahrzeugprofil Modal für Admin Dashboard
 */
?>
<!-- Vehicle Profile Modal -->
<div id="vehicle-profile-modal" class="modal" style="display: none;">
    <div class="modal-content" style="max-width: 800px;">
        <div class="modal-header">
            <h3><i class="fas fa-car"></i> Fahrzeug-Details</h3>
            <button class="modal-close" onclick="closeVehicleProfileModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body" id="vehicle-profile-content">
            <div style="text-align: center; padding: 3rem;">
                <i class="fas fa-spinner fa-spin" style="font-size: 3rem; color: #6c757d;"></i>
                <p style="margin-top: 1rem; color: #6c757d;">Lade Fahrzeug-Daten...</p>
            </div>
        </div>
    </div>
</div>

<style>
    .vehicle-profile-info {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
        margin-bottom: 2rem;
    }
    
    .vehicle-profile-info-item {
        padding: 1rem;
        background: #f8f9fa;
        border-radius: 8px;
        border: 1px solid #e9ecef;
    }
    
    .vehicle-profile-info-label {
        font-size: 0.85rem;
        color: #6c757d;
        margin-bottom: 0.5rem;
    }
    
    .vehicle-profile-info-value {
        font-weight: 600;
        color: #495057;
        font-size: 1.1rem;
    }
    
    .vehicle-profile-stats {
        display: flex;
        gap: 1rem;
        margin-bottom: 2rem;
    }
    
    .vehicle-profile-stat {
        flex: 1;
        padding: 1rem;
        background: linear-gradient(135deg, #003057 0%, #0056b3 100%);
        color: white;
        border-radius: 8px;
        text-align: center;
    }
    
    .vehicle-profile-stat-value {
        font-size: 2rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }
    
    .vehicle-profile-stat-label {
        font-size: 0.9rem;
        opacity: 0.9;
    }
    
    .vehicle-profile-appointments {
        margin-top: 1.5rem;
    }
    
    .vehicle-profile-appointments h4 {
        margin-bottom: 1rem;
        color: #003057;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    
    .vehicle-profile-appointment-card {
        padding: 1rem;
        background: #fff;
        border-radius: 8px;
        border: 2px solid #e9ecef;
        margin-bottom: 1rem;
        display: flex;
        justify-content: space-between;
        align-items: start;
    }
    
    .vehicle-profile-appointment-card:hover {
        border-color: #003057;
    }
    
    .vehicle-profile-appointment-info {
        flex: 1;
    }
    
    .vehicle-profile-appointment-title {
        font-weight: 600;
        color: #003057;
        margin-bottom: 0.5rem;
    }
    
    .vehicle-profile-appointment-details {
        font-size: 0.9rem;
        color: #6c757d;
        display: flex;
        gap: 1rem;
    }
    
    .vehicle-profile-appointment-status {
        padding: 0.5rem 1rem;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 600;
        white-space: nowrap;
    }
    
    .vehicle-profile-appointment-status.booked {
        background: #28a745;
        color: #fff;
    }
    
    .vehicle-profile-appointment-status.pending {
        background: #ffc107;
        color: #212529;
    }
    
    .vehicle-profile-appointment-status.cancelled {
        background: #dc3545;
        color: #fff;
    }
</style>

<script>
    async function showVehicleProfile(licensePlate, userId) {
        console.log('🔍 [showVehicleProfile] Start - License Plate:', licensePlate, 'User-ID:', userId);
        
        const modal = document.getElementById('vehicle-profile-modal');
        const content = document.getElementById('vehicle-profile-content');
        
        if (!modal || !content) {
            console.error('❌ [showVehicleProfile] Modal nicht gefunden');
            return;
        }
        
        modal.style.display = 'flex';
        content.innerHTML = `
            <div style="text-align: center; padding: 3rem;">
                <i class="fas fa-spinner fa-spin" style="font-size: 3rem; color: #6c757d;"></i>
                <p style="margin-top: 1rem; color: #6c757d;">Lade Fahrzeug-Daten...</p>
            </div>
        `;
        
        const apiUrl = '../api/get_customer_profile.php?user_id=' + userId;
        console.log('🔍 [showVehicleProfile] API-URL:', apiUrl);
        
        try {
            console.log('🔍 [showVehicleProfile] Starte Fetch-Request...');
            const response = await fetch(apiUrl);
            console.log('🔍 [showVehicleProfile] Response Status:', response.status, response.statusText);
            
            if (!response.ok) {
                console.error('❌ [showVehicleProfile] Response nicht OK:', response.status, response.statusText);
                const errorText = await response.text();
                console.error('❌ [showVehicleProfile] Error Response Text:', errorText);
                throw new Error('HTTP Error: ' + response.status);
            }
            
            const responseText = await response.text();
            console.log('🔍 [showVehicleProfile] Response Text:', responseText);
            
            let data;
            try {
                data = JSON.parse(responseText);
                console.log('✅ [showVehicleProfile] JSON geparst:', data);
            } catch (parseError) {
                console.error('❌ [showVehicleProfile] JSON Parse Error:', parseError);
                console.error('❌ [showVehicleProfile] Response Text war:', responseText);
                throw new Error('JSON Parse Error: ' + parseError.message);
            }
            
            if (data.success) {
                console.log('✅ [showVehicleProfile] Daten erfolgreich geladen');
                console.log('🔍 [showVehicleProfile] Vehicles:', data.vehicles);
                console.log('🔍 [showVehicleProfile] Suche nach License Plate:', licensePlate);
                
                // Finde das Fahrzeug mit dem Kennzeichen
                const vehicle = (data.vehicles || []).find(v => v.license_plate === licensePlate);
                console.log('🔍 [showVehicleProfile] Gefundenes Fahrzeug:', vehicle);
                
                if (vehicle) {
                    console.log('✅ [showVehicleProfile] Fahrzeug gefunden, generiere HTML');
                    content.innerHTML = generateVehicleProfileHTML(vehicle, data.appointments || [], data.user);
                } else {
                    console.warn('⚠️ [showVehicleProfile] Fahrzeug nicht gefunden für License Plate:', licensePlate);
                    console.log('🔍 [showVehicleProfile] Verfügbare License Plates:', (data.vehicles || []).map(v => v.license_plate));
                    content.innerHTML = `
                        <div style="text-align: center; padding: 3rem;">
                            <i class="fas fa-exclamation-triangle" style="font-size: 3rem; color: #ffc107;"></i>
                            <p style="margin-top: 1rem; color: #6c757d;">Fahrzeug nicht gefunden</p>
                            <p style="margin-top: 0.5rem; color: #6c757d; font-size: 0.9rem;">Kennzeichen: ${licensePlate}</p>
                        </div>
                    `;
                }
            } else {
                console.error('❌ [showVehicleProfile] API returned success: false', data);
                content.innerHTML = `
                    <div style="text-align: center; padding: 3rem;">
                        <i class="fas fa-exclamation-triangle" style="font-size: 3rem; color: #dc3545;"></i>
                        <p style="margin-top: 1rem; color: #dc3545;">Fehler beim Laden der Daten</p>
                        <p style="margin-top: 0.5rem; color: #6c757d; font-size: 0.9rem;">${data.message || 'Unbekannter Fehler'}</p>
                    </div>
                `;
            }
        } catch (error) {
            console.error('❌ [showVehicleProfile] CATCH Error:', error);
            console.error('❌ [showVehicleProfile] Error Stack:', error.stack);
            content.innerHTML = `
                <div style="text-align: center; padding: 3rem;">
                    <i class="fas fa-exclamation-triangle" style="font-size: 3rem; color: #dc3545;"></i>
                    <p style="margin-top: 1rem; color: #dc3545;">Verbindungsfehler</p>
                    <p style="margin-top: 0.5rem; color: #6c757d; font-size: 0.9rem;">${error.message || 'Unbekannter Fehler'}</p>
                </div>
            `;
        }
    }
    
    function generateVehicleProfileHTML(vehicle, appointments, user) {
        // Filtere Termine für dieses Fahrzeug
        const vehicleAppointments = appointments.filter(apt => apt.license_plate === vehicle.license_plate);
        
        // Statistiken
        const stats = {
            total_appointments: vehicleAppointments.length,
            upcoming_appointments: vehicleAppointments.filter(apt => {
                const aptDate = new Date(apt.event_date || apt.slot_date);
                return aptDate >= new Date();
            }).length,
            past_appointments: vehicleAppointments.filter(apt => {
                const aptDate = new Date(apt.event_date || apt.slot_date);
                return aptDate < new Date();
            }).length
        };
        
        return `
            <div class="vehicle-profile-info">
                <div class="vehicle-profile-info-item">
                    <div class="vehicle-profile-info-label">Kennzeichen</div>
                    <div class="vehicle-profile-info-value">
                        <i class="fas fa-car"></i> ${vehicle.license_plate}
                    </div>
                </div>
                ${vehicle.vehicle_brand ? `
                <div class="vehicle-profile-info-item">
                    <div class="vehicle-profile-info-label">Marke</div>
                    <div class="vehicle-profile-info-value">${vehicle.vehicle_brand}</div>
                </div>
                ` : ''}
                ${vehicle.vehicle_model ? `
                <div class="vehicle-profile-info-item">
                    <div class="vehicle-profile-info-label">Modell</div>
                    <div class="vehicle-profile-info-value">${vehicle.vehicle_model}</div>
                </div>
                ` : ''}
                ${vehicle.vehicle_year ? `
                <div class="vehicle-profile-info-item">
                    <div class="vehicle-profile-info-label">Baujahr</div>
                    <div class="vehicle-profile-info-value">${vehicle.vehicle_year}</div>
                </div>
                ` : ''}
            </div>
            
            ${vehicle.is_default ? `
            <div style="background: #fff3cd; border: 2px solid #ffc107; border-radius: 8px; padding: 1rem; margin-bottom: 1.5rem; text-align: center;">
                <i class="fas fa-star" style="color: #ffc107;"></i>
                <strong style="color: #856404;">Standard-Fahrzeug</strong>
            </div>
            ` : ''}
            
            ${vehicle.notes ? `
            <div style="background: #f8f9fa; border-radius: 8px; padding: 1rem; margin-bottom: 1.5rem;">
                <div style="font-weight: 600; margin-bottom: 0.5rem; color: #003057;">
                    <i class="fas fa-sticky-note"></i> Notizen
                </div>
                <div style="color: #495057;">${vehicle.notes}</div>
            </div>
            ` : ''}
            
            <div class="vehicle-profile-info">
                <div class="vehicle-profile-info-item">
                    <div class="vehicle-profile-info-label">Kunde</div>
                    <div class="vehicle-profile-info-value">${user.first_name} ${user.last_name}</div>
                </div>
                <div class="vehicle-profile-info-item">
                    <div class="vehicle-profile-info-label">E-Mail</div>
                    <div class="vehicle-profile-info-value">${user.email}</div>
                </div>
                <div class="vehicle-profile-info-item">
                    <div class="vehicle-profile-info-label">Hinzugefügt am</div>
                    <div class="vehicle-profile-info-value">${new Date(vehicle.created_at).toLocaleDateString('de-DE')}</div>
                </div>
            </div>
            
            <div class="vehicle-profile-stats">
                <div class="vehicle-profile-stat">
                    <div class="vehicle-profile-stat-value">${stats.total_appointments}</div>
                    <div class="vehicle-profile-stat-label">Gesamt Termine</div>
                </div>
                <div class="vehicle-profile-stat">
                    <div class="vehicle-profile-stat-value">${stats.upcoming_appointments}</div>
                    <div class="vehicle-profile-stat-label">Bevorstehend</div>
                </div>
                <div class="vehicle-profile-stat">
                    <div class="vehicle-profile-stat-value">${stats.past_appointments}</div>
                    <div class="vehicle-profile-stat-label">Vergangen</div>
                </div>
            </div>
            
            <div class="vehicle-profile-appointments">
                <h4><i class="fas fa-calendar-alt"></i> Termine für dieses Fahrzeug</h4>
                ${vehicleAppointments.length > 0 ? vehicleAppointments.map(apt => {
                    const date = new Date(apt.event_date).toLocaleDateString('de-DE');
                    const time = apt.event_time ? new Date('1970-01-01T' + apt.event_time).toLocaleTimeString('de-DE', { hour: '2-digit', minute: '2-digit' }) : '';
                    return `
                        <div class="vehicle-profile-appointment-card">
                            <div class="vehicle-profile-appointment-info">
                                <div class="vehicle-profile-appointment-title">${apt.event_name || 'Unbekannt'}</div>
                                <div class="vehicle-profile-appointment-details">
                                    <span><i class="fas fa-calendar"></i> ${date}</span>
                                    ${time ? `<span><i class="fas fa-clock"></i> ${time} Uhr</span>` : ''}
                                    ${apt.autohaus_name ? `<span><i class="fas fa-building"></i> ${apt.autohaus_name}</span>` : ''}
                                </div>
                            </div>
                            <span class="vehicle-profile-appointment-status ${apt.status}">${apt.status}</span>
                        </div>
                    `;
                }).join('') : '<p style="color: #6c757d; text-align: center; padding: 2rem;">Keine Termine für dieses Fahrzeug</p>'}
            </div>
        `;
    }
    
    function closeVehicleProfileModal() {
        document.getElementById('vehicle-profile-modal').style.display = 'none';
    }
    
    // Close modal when clicking outside
    document.getElementById('vehicle-profile-modal')?.addEventListener('click', function(e) {
        if (e.target === this) {
            closeVehicleProfileModal();
        }
    });
</script>

