<?php
/**
 * Prüft, ob PRT17 korrekt verbunden ist
 */

require_once __DIR__ . '/../config/printer.php';

echo "✅ PRT17 Verbindung prüfen\n";
echo str_repeat("=", 60) . "\n\n";

$printer_name = 'BUEK-PRT17';
$server_ip = PRINTER_SERVER_TAILSCALE_IP;

// 1. Prüfe, ob Drucker installiert ist
echo "1. Prüfe, ob Drucker installiert ist...\n";
$check_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $p = Get-Printer -Name \'%s\' -ErrorAction Stop; Write-Host \"✅ Drucker gefunden: $($p.Name)\"; Write-Host \"Status: $($p.PrinterStatus)\"; Write-Host \"Port: $($p.PortName)\"; Write-Host \"Driver: $($p.DriverName)\" } catch { Write-Host \"❌ Drucker nicht gefunden: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name)
);
exec($check_cmd, $check_output, $check_code);
$printer_found = false;
foreach ($check_output as $line) {
    echo "   $line\n";
    if (stripos($line, '✅') !== false || stripos($line, 'Drucker gefunden') !== false) {
        $printer_found = true;
    }
}
echo "\n";

if (!$printer_found) {
    echo "❌❌❌ DRUCKER NICHT GEFUNDEN!\n\n";
    echo "Bitte führen Sie zuerst aus:\n";
    echo "  php admin/connect_prt17.php\n\n";
    exit(1);
}

// 2. Test-Druck
echo "2. Test-Druck...\n";
$test_file = sys_get_temp_dir() . '\\test_prt17_' . date('His') . '.txt';
file_put_contents($test_file, "TEST PRT17\n" . date('Y-m-d H:i:s') . "\n");

$test_cmd = sprintf('print /D:"%s" "%s" 2>&1', $printer_name, $test_file);
exec($test_cmd, $test_output, $test_code);
$test_text = implode("\n", $test_output);
if (function_exists('mb_convert_encoding')) {
    $test_text = @mb_convert_encoding($test_text, 'UTF-8', 'Windows-1252');
}

echo "   Return Code: $test_code\n";
echo "   Ausgabe: $test_text\n";

$port_init_error = (stripos($test_text, 'konnte nicht initialisiert werden') !== false);

if ($port_init_error) {
    echo "   ❌ Port kann nicht initialisiert werden!\n\n";
    echo "   Lösung: Drucker erneut über Windows Explorer verbinden\n";
    echo "   und 'Anmeldedaten speichern' aktivieren.\n";
} else {
    echo "   ✅ Test-Druck erfolgreich!\n\n";
    
    // Prüfe Warteschlange
    echo "3. Prüfe Warteschlange...\n";
    sleep(2);
    $queue_cmd = sprintf(
        'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $jobs = Get-PrintJob -PrinterName \'%s\' -ErrorAction SilentlyContinue | Sort-Object SubmittedTime -Descending | Select-Object -First 1; if ($jobs) { Write-Host \"✅ Auftrag in Warteschlange: ID $($jobs.Id), Status: $($jobs.JobStatus)\" } else { Write-Host \"⚠️ Keine Aufträge (kann normal sein)\" } } catch { }" 2>&1',
        str_replace("'", "''", $printer_name)
    );
    exec($queue_cmd, $queue_output, $queue_code);
    foreach ($queue_output as $line) {
        echo "   $line\n";
    }
}

@unlink($test_file);

echo "\n";
echo str_repeat("=", 60) . "\n";
echo "ZUSAMMENFASSUNG\n";
echo str_repeat("=", 60) . "\n\n";

if ($port_init_error) {
    echo "❌ DRUCKER INSTALLIERT, ABER PORT KANN NICHT INITIALISIERT WERDEN\n\n";
    echo "Bitte verbinden Sie den Drucker erneut über Windows Explorer\n";
    echo "und aktivieren Sie 'Anmeldedaten speichern'.\n";
} else {
    echo "✅✅✅ PRT17 FUNKTIONIERT!\n\n";
    echo "Der Drucker ist korrekt installiert und kann drucken.\n";
    echo "Die API sollte jetzt auch funktionieren.\n";
}

