<?php
/**
 * Test-Seite für WhatsApp-Erinnerungen
 * Zeigt Fehler an
 */

// Fehler anzeigen
ini_set('display_errors', 1);
ini_set('log_errors', 1);
error_reporting(E_ALL);

echo "<h1>Test WhatsApp Reminders</h1>";

try {
    session_start();
    echo "<p>✓ Session gestartet</p>";
    
    require_once '../config/database.php';
    echo "<p>✓ Database geladen</p>";
    
    require_once 'includes/helpers.php';
    echo "<p>✓ Helpers geladen</p>";
    
    require_once 'includes/hellomateo_api.php';
    echo "<p>✓ HelloMateo API geladen</p>";
    
    require_once '../api/autohaus_whatsapp_notifications.php';
    echo "<p>✓ Autohaus WhatsApp Notifications geladen</p>";
    
    echo "<h2>✓ Alle Abhängigkeiten erfolgreich geladen!</h2>";
    echo "<p><a href='whatsapp_reminders_admin.php'>Zur Verwaltungsseite</a></p>";
    
} catch (Exception $e) {
    echo "<h2 style='color: red;'>FEHLER:</h2>";
    echo "<p style='color: red;'>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
}





