<?php
/**
 * Automatisches Test-Script für WhatsApp-Integration
 * Testet so lange, bis die Nachricht erfolgreich gesendet wurde und custom_fields korrekt gesetzt sind
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/includes/helpers.php';
require_once __DIR__ . '/includes/hellomateo_api.php';

// Konfiguration
$testPhone = '+491782465658';
$testName = 'Uludag';
$maxAttempts = 10;
$waitBetweenAttempts = 5; // Sekunden

// Hole Autohaus-ID (erste verfügbare oder aus GET)
$db = new Database();
$conn = $db->getConnection();

$autohausId = $_GET['autohaus_id'] ?? null;
if (!$autohausId) {
    $stmt = $conn->query("SELECT id FROM autohaus WHERE whatsapp_api_key IS NOT NULL AND whatsapp_api_key != '' LIMIT 1");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $autohausId = $result['id'] ?? null;
}

if (!$autohausId) {
    die("❌ Kein Autohaus mit WhatsApp API Key gefunden!\n");
}

echo "=== Automatischer WhatsApp-Test ===\n";
echo "Autohaus ID: {$autohausId}\n";
echo "Test Telefonnummer: {$testPhone}\n";
echo "Test Name: {$testName}\n";
echo "Max. Versuche: {$maxAttempts}\n";
echo "Wartezeit zwischen Versuchen: {$waitBetweenAttempts} Sekunden\n\n";

$api = new HelloMateoAPI(null, $autohausId);
$templateId = '692772f9-6841-41d0-a174-55b3145be4fa';

$attempt = 0;
$success = false;

while ($attempt < $maxAttempts && !$success) {
    $attempt++;
    echo "\n--- Versuch {$attempt}/{$maxAttempts} ---\n";
    echo "Zeit: " . date('Y-m-d H:i:s') . "\n";
    
    // Lösche alte Logs (optional)
    $logFile = __DIR__ . '/../logs/whatsapp_contact_debug.log';
    if ($attempt === 1 && file_exists($logFile)) {
        echo "ℹ️ Alte Logs werden gelöscht...\n";
        file_put_contents($logFile, '');
    }
    
    // Sende Nachricht
    echo "📤 Sende WhatsApp-Nachricht...\n";
    $placeholderValues = [
        'custom_fields.last_name' => $testName
    ];
    
    $result = $api->sendMessage(
        $testPhone,
        null, // Kein Text, nur Template
        $templateId,
        null, // Channel ID wird automatisch geholt
        $placeholderValues
    );
    
    echo "📥 API Response:\n";
    echo "  Success: " . ($result['success'] ? '✅ JA' : '❌ NEIN') . "\n";
    if (!$result['success']) {
        echo "  Error: " . ($result['error'] ?? 'Unbekannt') . "\n";
    }
    echo "  HTTP Code: " . ($result['http_code'] ?? 'N/A') . "\n";
    
    // Warte kurz, damit Logs geschrieben werden
    sleep(2);
    
    // Prüfe Logs
    echo "\n📋 Prüfe Logs...\n";
    $logContent = file_exists($logFile) ? file_get_contents($logFile) : '';
    
    $checks = [
        'field_created' => false,
        'field_has_value' => false,
        'message_sent' => false,
        'verification_ok' => false
    ];
    
    // Prüfe ob Field erstellt wurde
    if (strpos($logContent, 'Contact Custom Field \'last_name\' erfolgreich neu erstellt') !== false ||
        strpos($logContent, 'Contact Custom Field \'last_name\' erfolgreich aktualisiert') !== false) {
        $checks['field_created'] = true;
        echo "  ✅ Field wurde erstellt/aktualisiert\n";
    } else {
        echo "  ⚠️ Field wurde nicht erstellt/aktualisiert\n";
    }
    
    // Prüfe ob Field Wert hat
    if (strpos($logContent, 'Field hat korrekten Wert') !== false ||
        strpos($logContent, 'ist bereits gesetzt mit korrektem Wert') !== false) {
        $checks['field_has_value'] = true;
        echo "  ✅ Field hat korrekten Wert\n";
    } else {
        echo "  ⚠️ Field hat möglicherweise keinen korrekten Wert\n";
    }
    
    // Prüfe ob Nachricht gesendet wurde
    if ($result['success'] && ($result['http_code'] ?? 0) >= 200 && ($result['http_code'] ?? 0) < 300) {
        $checks['message_sent'] = true;
        echo "  ✅ Nachricht wurde gesendet (HTTP " . ($result['http_code'] ?? 'N/A') . ")\n";
    } else {
        echo "  ❌ Nachricht wurde nicht erfolgreich gesendet\n";
    }
    
    // Prüfe Verifizierung
    if (strpos($logContent, 'Verifizierung: custom_field \'last_name\' ist korrekt gesetzt') !== false) {
        $checks['verification_ok'] = true;
        echo "  ✅ Verifizierung erfolgreich\n";
    } else {
        echo "  ⚠️ Verifizierung nicht erfolgreich\n";
    }
    
    // Prüfe ob alles erfolgreich war
    $allChecksPassed = $checks['field_created'] && 
                       $checks['field_has_value'] && 
                       $checks['message_sent'] && 
                       $checks['verification_ok'];
    
    if ($allChecksPassed) {
        echo "\n🎉 ERFOLG! Alle Checks bestanden!\n";
        echo "✅ Field wurde erstellt/aktualisiert\n";
        echo "✅ Field hat korrekten Wert\n";
        echo "✅ Nachricht wurde gesendet\n";
        echo "✅ Verifizierung erfolgreich\n";
        $success = true;
    } else {
        echo "\n⚠️ Noch nicht erfolgreich. Fehlende Checks:\n";
        foreach ($checks as $check => $passed) {
            if (!$passed) {
                echo "  ❌ {$check}\n";
            }
        }
        
        if ($attempt < $maxAttempts) {
            echo "\n⏳ Warte {$waitBetweenAttempts} Sekunden vor nächstem Versuch...\n";
            sleep($waitBetweenAttempts);
        }
    }
    
    // Zeige letzte Log-Zeilen
    if ($logContent) {
        $logLines = explode("\n", $logContent);
        $lastLines = array_slice($logLines, -10);
        echo "\n📝 Letzte Log-Zeilen:\n";
        foreach ($lastLines as $line) {
            if (trim($line)) {
                echo "  " . $line . "\n";
            }
        }
    }
}

echo "\n=== Test abgeschlossen ===\n";
if ($success) {
    echo "✅ Test erfolgreich nach {$attempt} Versuch(en)!\n";
    echo "✅ Die WhatsApp-Nachricht sollte jetzt ankommen.\n";
    echo "✅ Bitte prüfe den HelloMateo-Chat auf den Fehler 'Key custom_fields.last_name not found in context'.\n";
    echo "✅ Wenn der Fehler nicht mehr erscheint, ist alles korrekt!\n";
} else {
    echo "❌ Test nach {$maxAttempts} Versuchen nicht erfolgreich.\n";
    echo "❌ Bitte prüfe die Logs manuell: {$logFile}\n";
    echo "❌ Mögliche Probleme:\n";
    echo "   - Rate Limit erreicht\n";
    echo "   - API Key ungültig\n";
    echo "   - PostgREST-Problem beim Setzen von custom_fields\n";
}

