<?php
/**
 * Test: Lade Templates direkt (ohne Session-Prüfung für Debugging)
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/includes/hellomateo_api.php';

header('Content-Type: application/json');

$autohausId = $_GET['autohaus_id'] ?? '1';

echo "Testing with autohaus_id: " . $autohausId . "\n\n";

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // 1. Prüfe ob API-Key in Datenbank existiert
    $stmt = $conn->prepare("SELECT id, name, whatsapp_api_key FROM autohaus WHERE id = ?");
    $stmt->execute([$autohausId]);
    $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$autohaus) {
        echo json_encode(['success' => false, 'error' => 'Autohaus nicht gefunden']);
        exit;
    }
    
    echo "Autohaus gefunden: " . $autohaus['name'] . "\n";
    echo "API-Key vorhanden: " . (!empty($autohaus['whatsapp_api_key']) ? 'JA' : 'NEIN') . "\n";
    echo "API-Key Länge: " . strlen($autohaus['whatsapp_api_key'] ?? '') . "\n\n";
    
    // 2. Erstelle HelloMateo API Instanz
    $autohausIdInt = intval($autohausId);
    echo "Erstelle HelloMateoAPI mit autohausId: " . $autohausIdInt . " (type: " . gettype($autohausIdInt) . ")\n";
    $hellomateo = new HelloMateoAPI(null, $autohausIdInt);
    
    // 3. Prüfe ob API-Key geladen wurde
    $apiKeyInfo = $hellomateo->getApiKeyInfo();
    echo "\nAPI-Key Info:\n";
    echo "  has_key: " . ($apiKeyInfo['has_key'] ? 'true' : 'false') . "\n";
    echo "  key_length: " . ($apiKeyInfo['key_length'] ?? 'N/A') . "\n";
    echo "  autohaus_id: " . ($apiKeyInfo['autohaus_id'] ?? 'N/A') . "\n\n";
    
    if (!$apiKeyInfo['has_key']) {
        echo json_encode([
            'success' => false, 
            'error' => 'API-Key konnte nicht geladen werden',
            'api_key_info' => $apiKeyInfo
        ], JSON_PRETTY_PRINT);
        exit;
    }
    
    // 4. Teste Verbindung
    echo "Teste Verbindung...\n";
    $testResult = $hellomateo->testConnection();
    echo "Connection Test:\n";
    echo "  success: " . ($testResult['success'] ? 'true' : 'false') . "\n";
    echo "  http_code: " . ($testResult['http_code'] ?? 'N/A') . "\n";
    if (!$testResult['success']) {
        echo "  error: " . ($testResult['error'] ?? 'N/A') . "\n";
    }
    echo "\n";
    
    // 5. Lade Templates
    echo "Lade Templates...\n";
    $result = $hellomateo->listTemplates(10, 0);
    echo "Templates Result:\n";
    echo "  success: " . ($result['success'] ? 'true' : 'false') . "\n";
    echo "  http_code: " . ($result['http_code'] ?? 'N/A') . "\n";
    if ($result['success']) {
        echo "  data_count: " . (is_array($result['data']) ? count($result['data']) : 0) . "\n";
    } else {
        echo "  error: " . ($result['error'] ?? 'N/A') . "\n";
    }
    
    echo "\n\n";
    echo json_encode([
        'success' => $result['success'],
        'error' => $result['error'] ?? null,
        'http_code' => $result['http_code'] ?? null,
        'data_count' => is_array($result['data']) ? count($result['data']) : 0
    ], JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    echo "\n\nException:\n";
    echo $e->getMessage() . "\n";
    echo $e->getTraceAsString() . "\n";
    
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'trace' => $e->getTraceAsString()
    ], JSON_PRETTY_PRINT);
}




