<?php
/**
 * Einfacher Test-Druck mit Warteschlangen-Prüfung
 */

require_once __DIR__ . '/../config/printer.php';

echo "🖨️ Einfacher Test-Druck\n";
echo str_repeat("=", 60) . "\n\n";

$printer_name = 'LABELPRINTER SERVICE';
$test_file = sys_get_temp_dir() . '\\test_print_' . date('His') . '.txt';
file_put_contents($test_file, "TEST DRUCK\n" . date('Y-m-d H:i:s') . "\nTEST-123\n");

echo "Test-Datei: $test_file\n";
echo "Drucker: $printer_name\n";
echo "Zeitstempel: " . date('Y-m-d H:i:s') . "\n\n";

// Prüfe Warteschlange VORHER
echo "1. Warteschlange VORHER:\n";
$queue_before_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $jobs = Get-PrintJob -PrinterName \'%s\' -ErrorAction SilentlyContinue | Sort-Object SubmittedTime -Descending; Write-Host \"Anzahl: $($jobs.Count)\"; foreach ($job in $jobs | Select-Object -First 5) { Write-Host \"  ID $($job.Id): Status=$($job.JobStatus), Zeit=$($job.SubmittedTime)\" } } catch { Write-Host \"Fehler: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name)
);
exec($queue_before_cmd, $queue_before_output, $queue_before_code);
$job_ids_before = [];
foreach ($queue_before_output as $line) {
    echo "   $line\n";
    if (preg_match('/ID (\d+):/', $line, $matches)) {
        $job_ids_before[] = $matches[1];
    }
}
echo "\n";

// Drucke
echo "2. Drucke Datei...\n";
$print_cmd = sprintf('print /D:"%s" "%s" 2>&1', $printer_name, $test_file);
exec($print_cmd, $print_output, $print_code);
$print_text = implode("\n", $print_output);
echo "   Return Code: $print_code\n";
echo "   Ausgabe: $print_text\n";
echo "\n";

// Warte kurz
echo "3. Warte 3 Sekunden...\n";
sleep(3);
echo "\n";

// Prüfe Warteschlange NACHHER
echo "4. Warteschlange NACHHER:\n";
exec($queue_before_cmd, $queue_after_output, $queue_after_code);
$job_ids_after = [];
$new_jobs = [];
foreach ($queue_after_output as $line) {
    echo "   $line\n";
    if (preg_match('/ID (\d+):/', $line, $matches)) {
        $job_id = $matches[1];
        $job_ids_after[] = $job_id;
        if (!in_array($job_id, $job_ids_before)) {
            $new_jobs[] = $job_id;
        }
    }
}
echo "\n";

// Ergebnis
echo str_repeat("=", 60) . "\n";
echo "ERGEBNIS:\n";
echo str_repeat("=", 60) . "\n\n";

if (!empty($new_jobs)) {
    echo "✅✅✅ NEUE AUFTRÄGE IN DER WARTESCHLANGE!\n";
    echo "   Neue Job-IDs: " . implode(', ', $new_jobs) . "\n";
    echo "   ✅ Der Druckauftrag ist beim Drucker angekommen!\n\n";
    echo "Bitte prüfen Sie auf dem Server (100.82.207.72):\n";
    echo "- Öffnen Sie die Drucker-Warteschlange\n";
    echo "- Prüfen Sie die neuen Aufträge (IDs: " . implode(', ', $new_jobs) . ")\n";
    echo "- Prüfen Sie den Status der Aufträge\n";
} else {
    echo "❌ Keine neuen Aufträge in der Warteschlange\n";
    echo "   Der Druckauftrag ist NICHT beim Drucker angekommen.\n\n";
    if (stripos($print_text, 'konnte nicht initialisiert werden') !== false) {
        echo "   Problem: Drucker-Port kann nicht initialisiert werden\n";
        echo "   Lösung: Drucker manuell über Windows Explorer verbinden\n";
    }
}

echo "\n";
echo "Aktuelle Warteschlange (alle Aufträge):\n";
$all_jobs_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $jobs = Get-PrintJob -PrinterName \'%s\' -ErrorAction SilentlyContinue | Sort-Object SubmittedTime -Descending; foreach ($job in $jobs) { Write-Host \"ID $($job.Id): Status=$($job.JobStatus), Besitzer=$($job.Owner), Zeit=$($job.SubmittedTime)\" } } catch { }" 2>&1',
    str_replace("'", "''", $printer_name)
);
exec($all_jobs_cmd, $all_jobs_output, $all_jobs_code);
foreach ($all_jobs_output as $line) {
    echo "   $line\n";
}

@unlink($test_file);









