<?php
/**
 * Entfernt den Drucker und bereitet manuelle Neuverbindung vor
 */

require_once __DIR__ . '/../config/printer.php';

echo "🔄 Drucker entfernen und neu verbinden\n";
echo str_repeat("=", 60) . "\n\n";

$printer_name_local = 'LABELPRINTER SERVICE';
$printer_name_server = 'labelprinter service';
$server_ip = PRINTER_SERVER_TAILSCALE_IP;
$server_user = PRINTER_SERVER_USER;
$server_pass = PRINTER_SERVER_PASS;

// 1. Lösche alle Druckaufträge
echo "1. Lösche alle Druckaufträge...\n";
$clear_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $jobs = Get-PrintJob -PrinterName \'%s\' -ErrorAction SilentlyContinue; foreach ($job in $jobs) { Remove-PrintJob -PrinterName \'%s\' -ID $job.Id -ErrorAction SilentlyContinue; Write-Host \"Gelöscht: ID $($job.Id)\" } } catch { }" 2>&1',
    str_replace("'", "''", $printer_name_local),
    str_replace("'", "''", $printer_name_local)
);
exec($clear_cmd, $clear_output, $clear_code);
if (!empty($clear_output)) {
    foreach ($clear_output as $line) {
        echo "   $line\n";
    }
} else {
    echo "   ✅ Keine Aufträge vorhanden\n";
}
echo "\n";

// 2. Entferne Drucker
echo "2. Entferne Drucker...\n";
$remove_cmd = sprintf(
    'rundll32 printui.dll,PrintUIEntry /dl /n "%s" 2>&1',
    $printer_name_local
);
exec($remove_cmd, $remove_output, $remove_code);
foreach ($remove_output as $line) {
    echo "   $line\n";
}
sleep(2);
echo "\n";

// 3. Trenne alle net use Verbindungen
echo "3. Trenne alle net use Verbindungen...\n";
exec('net use * /delete /yes 2>&1', $net_delete_output, $net_delete_code);
foreach ($net_delete_output as $line) {
    if (trim($line)) {
        echo "   $line\n";
    }
}
echo "\n";

// 4. Stelle neue net use Verbindung her
echo "4. Stelle neue net use Verbindung her...\n";
$net_use_cmd = sprintf(
    'net use "\\\\%s" %s /user:%s /persistent:yes 2>&1',
    $server_ip,
    $server_pass ? escapeshellarg($server_pass) : '',
    escapeshellarg($server_user)
);
exec($net_use_cmd, $net_use_output, $net_use_code);
foreach ($net_use_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 5. Öffne Windows Explorer
echo "5. Öffne Windows Explorer...\n";
$explorer_cmd = sprintf('explorer "\\\\%s"', $server_ip);
exec($explorer_cmd);
echo "   ✅ Windows Explorer geöffnet\n";
echo "\n";

echo str_repeat("=", 60) . "\n";
echo "📋 WICHTIGE ANLEITUNG - BITTE GENAU BEFOLGEN:\n";
echo str_repeat("=", 60) . "\n\n";

echo "⚠️⚠️⚠️ DIESER SCHRITT IST KRITISCH! ⚠️⚠️⚠️\n\n";

echo "1. Im Windows Explorer sollte '$printer_name_server' sichtbar sein\n";
echo "   (Drucker-Icon)\n\n";

echo "2. Rechtsklick auf '$printer_name_server'\n\n";

echo "3. Wähle 'Drucker verbinden' oder 'Connect'\n\n";

echo "4. WICHTIG: Wenn nach Credentials gefragt wird:\n";
echo "   Benutzer: $server_user\n";
echo "   Passwort: $server_pass\n";
echo "   ☑️☑️☑️ 'Anmeldedaten speichern' MUSS aktiviert sein! ☑️☑️☑️\n\n";

echo "5. Klicke 'OK' und warte, bis Installation abgeschlossen ist\n\n";

echo "6. Prüfe in Windows-Einstellungen → Drucker:\n";
echo "   - Der Drucker sollte als '$printer_name_local' erscheinen\n";
echo "   - Status sollte 'Bereit' oder 'Normal' sein (NICHT 'Fehler'!)\n\n";

echo "7. Teste Windows-Testseite:\n";
echo "   - Rechtsklick auf Drucker → 'Druckereigenschaften'\n";
echo "   - 'Testseite drucken'\n";
echo "   - Falls erfolgreich: ✅ Drucker funktioniert!\n\n";

echo str_repeat("=", 60) . "\n";
echo "🔍 NACH DER VERBINDUNG:\n";
echo str_repeat("=", 60) . "\n\n";

echo "Führen Sie aus:\n";
echo "  php admin/verify_printer_connection.php\n\n";

echo "Dieses Script prüft, ob der Drucker korrekt verbunden ist und\n";
echo "ob ein Test-Druck funktioniert.\n\n";

echo "✅ Wenn der Test-Druck erfolgreich ist, sollte auch die API funktionieren!\n\n";









