<?php
/**
 * Script zum Neuinstallieren des Druckers mit korrekter Authentifizierung
 */

require_once __DIR__ . '/../config/printer.php';

echo "🔄 Drucker-Neuinstallation\n";
echo str_repeat("=", 60) . "\n\n";

$printer_name = 'LABELPRINTER SERVICE';
$server_ip = PRINTER_SERVER_TAILSCALE_IP;
$server_user = PRINTER_SERVER_USER;
$server_pass = PRINTER_SERVER_PASS;

// 1. Stelle sicher, dass net use erfolgreich ist
echo "1. Stelle net use Verbindung her...\n";
$net_use_cmd = sprintf(
    'net use "\\\\%s" %s /user:%s 2>&1',
    $server_ip,
    $server_pass ? escapeshellarg($server_pass) : '',
    escapeshellarg($server_user)
);
exec($net_use_cmd, $net_use_output, $net_use_code);
foreach ($net_use_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 2. Lösche alten Drucker (falls vorhanden)
echo "2. Lösche alten Drucker...\n";
$delete_cmd = sprintf(
    'rundll32 printui.dll,PrintUIEntry /dl /n "%s" 2>&1',
    $printer_name
);
exec($delete_cmd, $delete_output, $delete_code);
foreach ($delete_output as $line) {
    echo "   $line\n";
}
sleep(2);
echo "\n";

// 3. Starte Druckerdienst neu
echo "3. Starte Windows-Druckerdienst neu...\n";
echo "   Stoppe Dienst...\n";
exec('net stop spooler 2>&1', $stop_output, $stop_code);
foreach ($stop_output as $line) {
    echo "   $line\n";
}
sleep(2);

echo "   Starte Dienst...\n";
exec('net start spooler 2>&1', $start_output, $start_code);
foreach ($start_output as $line) {
    echo "   $line\n";
}
sleep(3);
echo "\n";

// 4. Installiere Drucker neu mit PowerShell (expliziter Port)
echo "4. Installiere Drucker neu...\n";
$port_name = "\\\\$server_ip\\$printer_name";
$install_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { Add-Printer -Name \'%s\' -DriverName \'Bar Code Printer TTP068-50\' -PortName \'%s\' -ErrorAction Stop; Write-Host \"Drucker installiert\" } catch { Write-Host \"Fehler: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name),
    str_replace("'", "''", $port_name)
);
exec($install_cmd, $install_output, $install_code);
foreach ($install_output as $line) {
    echo "   $line\n";
}
sleep(2);
echo "\n";

// 5. Prüfe Installation
echo "5. Prüfe Installation...\n";
$check_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $p = Get-Printer -Name \'%s\' -ErrorAction Stop; Write-Host \"✅ Drucker gefunden\"; Write-Host \"Status: $($p.PrinterStatus)\"; Write-Host \"Port: $($p.PortName)\" } catch { Write-Host \"❌ Drucker nicht gefunden: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name)
);
exec($check_cmd, $check_output, $check_code);
foreach ($check_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 6. Setze als Standard-Drucker
echo "6. Setze als Standard-Drucker...\n";
$set_default_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { Set-Printer -Name \'%s\' -IsDefault -ErrorAction Stop; Write-Host \"Als Standard gesetzt\" } catch { Write-Host \"Fehler: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name)
);
exec($set_default_cmd, $set_default_output, $set_default_code);
foreach ($set_default_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 7. Test-Druck
echo "7. Test-Druck...\n";
$test_file = sys_get_temp_dir() . '\\test_print.txt';
file_put_contents($test_file, "TEST DRUCK\n" . date('Y-m-d H:i:s') . "\n");

$test_print_cmd = sprintf(
    'print /D:"%s" "%s" 2>&1',
    $printer_name,
    $test_file
);
exec($test_print_cmd, $test_print_output, $test_print_code);
$test_print_text = implode("\n", $test_print_output);
echo "   Return Code: $test_print_code\n";
echo "   Ausgabe: $test_print_text\n";

if (stripos($test_print_text, 'konnte nicht initialisiert werden') !== false) {
    echo "   ❌ Port kann immer noch nicht initialisiert werden!\n\n";
    echo "   💡 Das Problem liegt wahrscheinlich an der Windows-Berechtigung.\n";
    echo "   Versuche folgendes:\n";
    echo "   1. Führe dieses Script als Administrator aus\n";
    echo "   2. Oder installiere den Drucker manuell:\n";
    echo "      - Windows Explorer → \\\\$server_ip\n";
    echo "      - Rechtsklick auf '$printer_name' → 'Drucker verbinden'\n";
    echo "      - Verwende Credentials: $server_user\n";
} else {
    echo "   ✅ Test-Druck erfolgreich!\n";
}

@unlink($test_file);

echo "\n" . str_repeat("=", 60) . "\n";
echo "Fertig!\n";









