-- Migration: WhatsApp-Erinnerungssystem Erweiterungen
-- Datum: 2024-01-XX
-- Beschreibung: Fügt Felder für WhatsApp-Bestätigungen und Opt-out hinzu

-- Erweiterungen für appointments Tabelle
ALTER TABLE appointments 
ADD COLUMN IF NOT EXISTS whatsapp_confirmation_sent TINYINT(1) DEFAULT 0 
COMMENT 'WhatsApp-Bestätigung bei Buchung gesendet',
ADD COLUMN IF NOT EXISTS whatsapp_confirmation_sent_at TIMESTAMP NULL 
COMMENT 'Zeitpunkt der gesendeten WhatsApp-Bestätigung';

-- Opt-out für Kunden (optional, aber empfohlen für DSGVO)
ALTER TABLE users 
ADD COLUMN IF NOT EXISTS whatsapp_opt_out TINYINT(1) DEFAULT 0 
COMMENT 'Kunde möchte keine WhatsApp-Benachrichtigungen erhalten';

-- Index für bessere Performance bei WhatsApp-Erinnerungen
CREATE INDEX IF NOT EXISTS idx_appointments_whatsapp_reminder 
ON appointments(whatsapp_reminder_sent, slot_date, status, autohaus_id);

-- Index für Bestätigungen
CREATE INDEX IF NOT EXISTS idx_appointments_whatsapp_confirmation 
ON appointments(whatsapp_confirmation_sent, created_at, status);

-- Index für Opt-out Prüfung
CREATE INDEX IF NOT EXISTS idx_users_whatsapp_opt_out 
ON users(whatsapp_opt_out, phone_number);

-- Kommentar hinzufügen für bestehende Felder (falls noch nicht vorhanden)
ALTER TABLE appointments 
MODIFY COLUMN whatsapp_reminder_sent TINYINT(1) DEFAULT 0 
COMMENT 'WhatsApp-Erinnerung für diesen Termin gesendet';

ALTER TABLE appointments 
MODIFY COLUMN whatsapp_reminder_sent_at TIMESTAMP NULL 
COMMENT 'Zeitpunkt der gesendeten WhatsApp-Erinnerung';





