-- Migration: Drucker-Einstellungen pro Autohaus hinzufügen
-- Datum: 2025-01-XX

-- Füge Drucker-Felder zur autohaus Tabelle hinzu
ALTER TABLE `autohaus` 
ADD COLUMN `printer_name` VARCHAR(255) NULL DEFAULT NULL COMMENT 'Lokaler Druckername (z.B. PRT17_BUEK-Server)' AFTER `tire_offers_api_key_required`,
ADD COLUMN `printer_server_ip` VARCHAR(50) NULL DEFAULT NULL COMMENT 'Drucker-Server IP (z.B. 100.82.207.72)' AFTER `printer_name`,
ADD COLUMN `printer_server_hostname` VARCHAR(255) NULL DEFAULT NULL COMMENT 'Drucker-Server Hostname (z.B. buek-s01)' AFTER `printer_server_ip`,
ADD COLUMN `printer_server_user` VARCHAR(255) NULL DEFAULT NULL COMMENT 'Drucker-Server Benutzername (z.B. VOLVOKIE\Projekt)' AFTER `printer_server_hostname`,
ADD COLUMN `printer_server_pass` VARCHAR(255) NULL DEFAULT NULL COMMENT 'Drucker-Server Passwort' AFTER `printer_server_user`,
ADD COLUMN `printer_name_server` VARCHAR(255) NULL DEFAULT NULL COMMENT 'Druckername auf Server (z.B. BUEK-PRT17)' AFTER `printer_server_pass`,
ADD COLUMN `printer_name_local` VARCHAR(255) NULL DEFAULT NULL COMMENT 'Lokaler Druckername nach Installation (z.B. PRT17_BUEK-Server)' AFTER `printer_name_server`,
ADD COLUMN `printer_enabled` TINYINT(1) DEFAULT 1 COMMENT 'Drucker aktiviert (1=ja, 0=nein)' AFTER `printer_name_local`;

-- Index für bessere Performance
CREATE INDEX `idx_autohaus_printer_enabled` ON `autohaus` (`printer_enabled`);

-- Setze Standard-Werte für bestehende Autohäuser (basierend auf config/printer.php)
UPDATE `autohaus` SET
    `printer_name` = 'PRT17_BUEK-Server',
    `printer_server_ip` = '100.82.207.72',
    `printer_server_hostname` = 'buek-s01',
    `printer_server_user` = 'VOLVOKIE\Projekt',
    `printer_server_pass` = 'start#2025',
    `printer_name_server` = 'BUEK-PRT17',
    `printer_name_local` = 'PRT17_BUEK-Server',
    `printer_enabled` = 1
WHERE `printer_name` IS NULL;







