<?php
/**
 * Installiert BUEK-PRT17 von buek-s01 auf dem API-Server
 * Versucht verschiedene Methoden, um den Drucker zu verbinden
 */

require_once __DIR__ . '/../config/printer.php';

echo "🔌 BUEK-PRT17 Drucker-Installation\n";
echo str_repeat("=", 60) . "\n\n";

$printer_name = 'BUEK-PRT17';
$server_hostname = PRINTER_SERVER_HOSTNAME; // buek-s01
$server_ip = PRINTER_SERVER_TAILSCALE_IP; // 100.82.207.72
$server_user = PRINTER_SERVER_USER;
$server_pass = PRINTER_SERVER_PASS;

echo "Drucker: $printer_name\n";
echo "Server: $server_hostname ($server_ip)\n";
echo "Benutzer: $server_user\n\n";

// 1. Stelle net use Verbindung her
echo "1. Stelle net use Verbindung her...\n";
$net_use_cmd = sprintf(
    'net use "\\\\%s" %s /user:%s 2>&1',
    $server_ip,
    $server_pass ? escapeshellarg($server_pass) : '',
    escapeshellarg($server_user)
);
exec($net_use_cmd, $net_use_output, $net_use_code);
foreach ($net_use_output as $line) {
    echo "   $line\n";
}
$net_use_success = ($net_use_code === 0);
echo "   " . ($net_use_success ? "✅ Erfolgreich" : "❌ Fehlgeschlagen") . "\n\n";

// 2. Prüfe, ob Drucker bereits installiert ist
echo "2. Prüfe vorhandene Drucker...\n";
$check_cmd = 'wmic printer get name 2>&1';
exec($check_cmd, $check_output, $check_code);
$already_installed = false;
foreach ($check_output as $line) {
    $line_trimmed = trim($line);
    if (stripos($line_trimmed, $printer_name) !== false || 
        (stripos($line_trimmed, 'BUEK') !== false && stripos($line_trimmed, 'PRT') !== false)) {
        echo "   ⚠️ Drucker bereits gefunden: $line_trimmed\n";
        $already_installed = true;
    }
}
if (!$already_installed) {
    echo "   ✅ Drucker noch nicht installiert\n";
}
echo "\n";

// 3. Lösche alten Drucker (falls vorhanden)
if ($already_installed) {
    echo "3. Lösche alten Drucker...\n";
    $delete_cmd = sprintf('rundll32 printui.dll,PrintUIEntry /dl /n "%s" 2>&1', $printer_name);
    exec($delete_cmd, $delete_output, $delete_code);
    foreach ($delete_output as $line) {
        echo "   $line\n";
    }
    sleep(2);
    echo "\n";
}

// 4. Methode 1: Windows Explorer (öffnet Dialog)
echo "4. Methode 1: Öffne Windows Explorer für manuelle Installation...\n";
$explorer_cmd = sprintf('explorer "\\\\%s"', $server_ip);
exec($explorer_cmd);
echo "   ✅ Windows Explorer geöffnet\n";
echo "   📋 ANLEITUNG:\n";
echo "   1. Im Explorer sollte '$printer_name' sichtbar sein\n";
echo "   2. Rechtsklick auf '$printer_name'\n";
echo "   3. Wähle 'Drucker verbinden' oder 'Connect'\n";
echo "   4. Wenn nach Credentials gefragt wird:\n";
echo "      Benutzer: $server_user\n";
echo "      Passwort: [Ihr Passwort]\n";
echo "   5. Warte, bis Installation abgeschlossen ist\n";
echo "\n";

// 5. Methode 2: Rundll32 (automatisch)
echo "5. Methode 2: Automatische Installation mit rundll32...\n";
$install_cmd1 = sprintf(
    'rundll32 printui.dll,PrintUIEntry /in /n "\\\\%s\\%s" 2>&1',
    $server_ip,
    $printer_name
);
exec($install_cmd1, $install_output1, $install_code1);
echo "   Return Code: $install_code1\n";
foreach ($install_output1 as $line) {
    echo "   $line\n";
}
sleep(3);

// Prüfe, ob erfolgreich
exec($check_cmd, $check_output2, $check_code2);
$installed_method2 = false;
foreach ($check_output2 as $line) {
    if (stripos($line, $printer_name) !== false) {
        echo "   ✅ Drucker installiert (rundll32)\n";
        $installed_method2 = true;
        break;
    }
}
if (!$installed_method2) {
    echo "   ❌ Installation fehlgeschlagen (rundll32)\n";
}
echo "\n";

// 6. Methode 3: PowerShell Add-Printer (ConnectionName)
if (!$installed_method2) {
    echo "6. Methode 3: PowerShell Add-Printer (ConnectionName)...\n";
    $unc_path = "\\\\$server_ip\\$printer_name";
    $install_cmd2 = sprintf(
        'powershell -NoProfile -ExecutionPolicy Bypass -Command "$ErrorActionPreference = \'Stop\'; try { Add-Printer -ConnectionName \'%s\' -ErrorAction Stop; Write-Host \'SUCCESS\' } catch { Write-Host $_.Exception.Message }" 2>&1',
        str_replace("'", "''", $unc_path)
    );
    exec($install_cmd2, $install_output2, $install_code2);
    echo "   Return Code: $install_code2\n";
    foreach ($install_output2 as $line) {
        echo "   $line\n";
    }
    sleep(2);
    
    exec($check_cmd, $check_output3, $check_code3);
    $installed_method3 = false;
    foreach ($check_output3 as $line) {
        if (stripos($line, $printer_name) !== false) {
            echo "   ✅ Drucker installiert (PowerShell ConnectionName)\n";
            $installed_method3 = true;
            break;
        }
    }
    if (!$installed_method3) {
        echo "   ❌ Installation fehlgeschlagen (PowerShell ConnectionName)\n";
    }
    echo "\n";
}

// 7. Methode 4: PowerShell Add-Printer mit explizitem Port
if (!$installed_method2 && !$installed_method3) {
    echo "7. Methode 4: PowerShell Add-Printer mit explizitem Port...\n";
    $port_name = "\\\\$server_ip\\$printer_name";
    $install_cmd3 = sprintf(
        'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { Add-Printer -Name \'%s\' -DriverName \'Bar Code Printer TTP068-50\' -PortName \'%s\' -ErrorAction Stop; Write-Host \'SUCCESS\' } catch { Write-Host $_.Exception.Message }" 2>&1',
        str_replace("'", "''", $printer_name),
        str_replace("'", "''", $port_name)
    );
    exec($install_cmd3, $install_output3, $install_code3);
    echo "   Return Code: $install_code3\n";
    foreach ($install_output3 as $line) {
        echo "   $line\n";
    }
    sleep(2);
    
    exec($check_cmd, $check_output4, $check_code4);
    $installed_method4 = false;
    foreach ($check_output4 as $line) {
        if (stripos($line, $printer_name) !== false) {
            echo "   ✅ Drucker installiert (PowerShell mit Port)\n";
            $installed_method4 = true;
            break;
        }
    }
    if (!$installed_method4) {
        echo "   ❌ Installation fehlgeschlagen (PowerShell mit Port)\n";
    }
    echo "\n";
}

// 8. Finale Prüfung
echo "8. Finale Prüfung...\n";
exec($check_cmd, $final_output, $final_code);
$final_installed = false;
$installed_name = '';
foreach ($final_output as $line) {
    $line_trimmed = trim($line);
    if (stripos($line_trimmed, $printer_name) !== false || 
        (stripos($line_trimmed, 'BUEK') !== false && stripos($line_trimmed, 'PRT') !== false)) {
        $final_installed = true;
        $installed_name = $line_trimmed;
        echo "   ✅ Drucker gefunden: $line_trimmed\n";
        
        // Prüfe Status
        $status_cmd = sprintf(
            'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $p = Get-Printer -Name \'%s\' -ErrorAction Stop; Write-Host \"Status: $($p.PrinterStatus)\"; Write-Host \"Port: $($p.PortName)\" } catch { }" 2>&1',
            str_replace("'", "''", $line_trimmed)
        );
        exec($status_cmd, $status_output, $status_code);
        foreach ($status_output as $status_line) {
            echo "      $status_line\n";
        }
        break;
    }
}

if (!$final_installed) {
    echo "   ❌ Drucker nicht gefunden\n";
}
echo "\n";

// 9. Test-Druck
if ($final_installed) {
    echo "9. Test-Druck...\n";
    $test_file = sys_get_temp_dir() . '\\test_buek_prt17.txt';
    file_put_contents($test_file, "TEST BUEK-PRT17\n" . date('Y-m-d H:i:s') . "\n");
    
    $test_cmd = sprintf('print /D:"%s" "%s" 2>&1', $installed_name ?: $printer_name, $test_file);
    exec($test_cmd, $test_output, $test_code);
    $test_text = implode("\n", $test_output);
    echo "   Return Code: $test_code\n";
    echo "   Ausgabe: $test_text\n";
    
    if (stripos($test_text, 'konnte nicht initialisiert werden') === false) {
        echo "   ✅ Test-Druck erfolgreich!\n";
    } else {
        echo "   ❌ Port kann nicht initialisiert werden\n";
        echo "   💡 Lösung: Drucker manuell über Windows Explorer verbinden\n";
    }
    
    @unlink($test_file);
    echo "\n";
}

// Zusammenfassung
echo str_repeat("=", 60) . "\n";
echo "ZUSAMMENFASSUNG\n";
echo str_repeat("=", 60) . "\n\n";

if ($final_installed) {
    echo "✅ Drucker installiert: $installed_name\n\n";
    echo "Nächste Schritte:\n";
    echo "1. Prüfe, ob der Drucker in Windows-Einstellungen sichtbar ist\n";
    echo "2. Versuche Windows-Testseite zu drucken\n";
    echo "3. Falls Port nicht initialisiert werden kann:\n";
    echo "   - Öffne Windows Explorer → \\\\$server_ip\n";
    echo "   - Rechtsklick auf '$printer_name' → 'Drucker verbinden'\n";
    echo "   - Verwende Credentials: $server_user\n";
} else {
    echo "❌ Automatische Installation fehlgeschlagen\n\n";
    echo "MANUELLE INSTALLATION ERFORDERLICH:\n\n";
    echo "1. Windows Explorer sollte bereits geöffnet sein\n";
    echo "2. Falls nicht, öffne: \\\\$server_ip\n";
    echo "3. Rechtsklick auf '$printer_name'\n";
    echo "4. Wähle 'Drucker verbinden' oder 'Connect'\n";
    echo "5. Bei Credentials-Abfrage:\n";
    echo "   Benutzer: $server_user\n";
    echo "   Passwort: [Ihr Passwort]\n";
    echo "6. Warte, bis Installation abgeschlossen ist\n";
    echo "7. Prüfe in Windows-Einstellungen → Drucker\n";
}

echo "\n";
echo "💡 TIPP: Nach manueller Installation sollte der Drucker funktionieren,\n";
echo "   da Windows die Authentifizierung für den UNC-Port speichert.\n";









