<?php
/**
 * Helper Functions für Admin-Bereich
 * Enthält gemeinsame Hilfsfunktionen
 */

/**
 * Fügt Cache-Busting-Parameter zu CSS/JS-Dateien hinzu
 * Verwendet filemtime für automatische Versionierung
 * 
 * @param string $file_path Relativer Pfad zur Datei (z.B. 'assets/css/unified-sidebar.css')
 * @return string URL mit Version-Parameter
 */
function asset_url($file_path) {
    // Basis-Pfad zum Admin-Verzeichnis
    $base_path = __DIR__ . '/../';
    $full_path = $base_path . $file_path;
    
    // Prüfe ob Datei existiert
    if (!file_exists($full_path)) {
        // Fallback: Datei ohne Version zurückgeben
        return $file_path;
    }
    
    // Hole Änderungszeit der Datei
    $file_time = filemtime($full_path);
    
    // Füge Version-Parameter hinzu
    $separator = strpos($file_path, '?') !== false ? '&' : '?';
    return $file_path . $separator . 'v=' . $file_time;
}
?>

