<?php
/**
 * Findet PRT17 auf dem Server über VPN
 */

require_once __DIR__ . '/../config/printer.php';

echo "🔍 Suche PRT17 auf Server\n";
echo str_repeat("=", 60) . "\n\n";

$server_ip = PRINTER_SERVER_TAILSCALE_IP;
$server_user = PRINTER_SERVER_USER;
$server_pass = PRINTER_SERVER_PASS;

// 1. Stelle net use Verbindung her
echo "1. Stelle net use Verbindung her...\n";
$net_use_cmd = sprintf(
    'net use "\\\\%s" %s /user:%s /persistent:yes 2>&1',
    $server_ip,
    $server_pass ? escapeshellarg($server_pass) : '',
    escapeshellarg($server_user)
);
exec($net_use_cmd, $net_use_output, $net_use_code);
foreach ($net_use_output as $line) {
    if (trim($line)) {
        echo "   $line\n";
    }
}
echo "\n";

// 2. Liste alle Freigaben auf dem Server
echo "2. Liste alle Freigaben auf dem Server...\n";
$net_view_cmd = sprintf('net view "\\\\%s" 2>&1', $server_ip);
exec($net_view_cmd, $net_view_output, $net_view_code);
echo "   Return Code: $net_view_code\n";

$all_shares = [];
$printer_shares = [];
$prt17_found = false;
$prt17_name = '';

foreach ($net_view_output as $line) {
    echo "   $line\n";
    
    // Suche nach Druckern
    if (stripos($line, 'Drucker') !== false) {
        // Extrahiere den Freigabenamen
        preg_match('/^([^\s]+)\s+Drucker/', $line, $matches);
        if (isset($matches[1])) {
            $share_name = trim($matches[1]);
            $printer_shares[] = $share_name;
            echo "      ✅ Drucker gefunden: $share_name\n";
            
            // Prüfe, ob es PRT17 ist
            if (stripos($share_name, 'PRT17') !== false || 
                stripos($share_name, 'PRT-17') !== false ||
                stripos($share_name, 'BUEK-PRT17') !== false ||
                stripos($share_name, 'BUEK') !== false) {
                $prt17_found = true;
                $prt17_name = $share_name;
                echo "      ✅✅✅ PRT17 GEFUNDEN: $share_name\n";
            }
        }
    }
    
    // Sammle alle Freigaben
    if (trim($line) && stripos($line, 'Freigabename') === false && 
        stripos($line, 'Typ') === false && stripos($line, '---') === false &&
        stripos($line, 'Der Befehl wurde') === false) {
        $all_shares[] = trim($line);
    }
}

echo "\n";
echo "Gefundene Drucker-Freigaben:\n";
foreach ($printer_shares as $share) {
    echo "   - $share\n";
}
echo "\n";

// 3. Prüfe auch über PowerShell Get-Printer (falls möglich)
echo "3. Versuche PowerShell Get-Printer auf Server...\n";
$ps_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $printers = Get-Printer -ComputerName \'%s\' -ErrorAction Stop; foreach ($p in $printers) { Write-Host \"$($p.Name) - $($p.PrinterStatus)\" } } catch { Write-Host \"Fehler: $_\" }" 2>&1',
    $server_ip
);
exec($ps_cmd, $ps_output, $ps_code);
if (!empty($ps_output)) {
    foreach ($ps_output as $line) {
        echo "   $line\n";
        if (stripos($line, 'PRT17') !== false || stripos($line, 'PRT-17') !== false) {
            $prt17_found = true;
            if (empty($prt17_name)) {
                preg_match('/([^\s]+)/', $line, $matches);
                if (isset($matches[1])) {
                    $prt17_name = $matches[1];
                }
            }
        }
    }
} else {
    echo "   ⚠️ PowerShell-Zugriff nicht möglich (normal bei Netzwerkdruckern)\n";
}
echo "\n";

// 4. Prüfe, ob PRT17 lokal installiert ist
echo "4. Prüfe, ob PRT17 lokal installiert ist...\n";
$local_check_cmd = 'wmic printer get name 2>&1';
exec($local_check_cmd, $local_check_output, $local_check_code);
$prt17_local = false;
foreach ($local_check_output as $line) {
    if (stripos($line, 'PRT17') !== false || 
        stripos($line, 'PRT-17') !== false ||
        stripos($line, 'BUEK-PRT17') !== false) {
        echo "   ✅ PRT17 lokal gefunden: $line\n";
        $prt17_local = true;
    }
}
if (!$prt17_local) {
    echo "   ❌ PRT17 nicht lokal installiert\n";
}
echo "\n";

// 5. Zusammenfassung und Empfehlung
echo str_repeat("=", 60) . "\n";
echo "ZUSAMMENFASSUNG\n";
echo str_repeat("=", 60) . "\n\n";

if ($prt17_found) {
    echo "✅✅✅ PRT17 GEFUNDEN!\n\n";
    echo "Drucker-Name auf Server: $prt17_name\n";
    echo "UNC-Pfad: \\\\$server_ip\\$prt17_name\n\n";
    
    echo "📋 NÄCHSTE SCHRITTE:\n\n";
    echo "1. Öffne Windows Explorer\n";
    echo "2. Gebe ein: \\\\$server_ip\n";
    echo "3. Suche nach '$prt17_name'\n";
    echo "4. Rechtsklick → 'Drucker verbinden'\n";
    echo "5. WICHTIG: 'Anmeldedaten speichern' aktivieren\n";
    echo "6. Credentials: $server_user / [Passwort]\n\n";
    
    echo "💡 Die Konfiguration wird automatisch aktualisiert, um PRT17 zu verwenden.\n";
} else {
    echo "❌ PRT17 NICHT GEFUNDEN!\n\n";
    echo "Gefundene Drucker:\n";
    foreach ($printer_shares as $share) {
        echo "   - $share\n";
    }
    echo "\n";
    
    echo "⚠️ MÖGLICHE URSACHEN:\n";
    echo "1. PRT17 ist nicht als Netzwerkdrucker freigegeben\n";
    echo "2. PRT17 hat einen anderen Namen\n";
    echo "3. PRT17 ist nur lokal auf dem Server verfügbar\n\n";
    
    echo "📋 LÖSUNG:\n";
    echo "Auf dem Server (100.82.207.72) muss PRT17 als Netzwerkdrucker freigegeben werden:\n\n";
    echo "1. Öffne auf dem Server: Systemsteuerung → Drucker\n";
    echo "2. Rechtsklick auf 'PRT17' oder 'BUEK-PRT17'\n";
    echo "3. Wähle 'Druckereigenschaften'\n";
    echo "4. Gehe zu 'Freigabe'\n";
    echo "5. Aktiviere 'Drucker freigeben'\n";
    echo "6. Freigabename: 'PRT17' oder 'BUEK-PRT17'\n";
    echo "7. Klicke 'OK'\n\n";
    
    echo "Nach der Freigabe:\n";
    echo "- Der Drucker sollte in net view sichtbar sein\n";
    echo "- Kann über \\\\$server_ip\\PRT17 verbunden werden\n";
}

echo "\n";
echo "🔧 KONFIGURATION AKTUALISIEREN:\n";
echo "Die config/printer.php wird aktualisiert, um PRT17 zu verwenden.\n";

