<?php
/**
 * Umfassende Drucker-Diagnose
 */

require_once __DIR__ . '/../config/printer.php';

echo "🔍 Drucker-Diagnose\n";
echo str_repeat("=", 60) . "\n\n";

$printer_name = 'LABELPRINTER SERVICE';
$server_ip = PRINTER_SERVER_TAILSCALE_IP;

// 1. Prüfe Windows-Ereignisanzeige für Drucker-Fehler
echo "1. Prüfe Windows-Ereignisanzeige (letzte 5 Drucker-Fehler)...\n";
$event_cmd = 'powershell -NoProfile -ExecutionPolicy Bypass -Command "Get-EventLog -LogName System -Source \"Print\" -Newest 5 -ErrorAction SilentlyContinue | Select-Object TimeGenerated, EntryType, Message | Format-List" 2>&1';
exec($event_cmd, $event_output, $event_code);
if (!empty($event_output)) {
    foreach ($event_output as $line) {
        echo "   $line\n";
    }
} else {
    echo "   Keine Ereignisse gefunden\n";
}
echo "\n";

// 2. Prüfe Drucker-Warteschlange
echo "2. Prüfe Drucker-Warteschlange...\n";
$queue_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $jobs = Get-PrintJob -PrinterName \'%s\' -ErrorAction Stop; Write-Host \"Anzahl Aufträge: $($jobs.Count)\"; foreach ($job in $jobs) { Write-Host \"  - $($job.Name): $($job.JobStatus)\" } } catch { Write-Host \"Fehler oder keine Aufträge: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name)
);
exec($queue_cmd, $queue_output, $queue_code);
foreach ($queue_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 3. Prüfe Drucker-Status detailliert
echo "3. Detaillierter Drucker-Status...\n";
$detailed_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $p = Get-Printer -Name \'%s\' -ErrorAction Stop; Write-Host \"Name: $($p.Name)\"; Write-Host \"Status: $($p.PrinterStatus)\"; Write-Host \"Port: $($p.PortName)\"; Write-Host \"Driver: $($p.DriverName)\"; Write-Host \"Location: $($p.Location)\"; Write-Host \"Comment: $($p.Comment)\"; Write-Host \"Shared: $($p.Shared)\"; Write-Host \"Published: $($p.Published)\" } catch { Write-Host \"Fehler: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name)
);
exec($detailed_cmd, $detailed_output, $detailed_code);
foreach ($detailed_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 4. Prüfe, ob Server erreichbar ist
echo "4. Prüfe Server-Erreichbarkeit...\n";
$ping_cmd = sprintf('ping -n 2 %s 2>&1', $server_ip);
exec($ping_cmd, $ping_output, $ping_code);
foreach ($ping_output as $line) {
    if (stripos($line, 'Antwort') !== false || stripos($line, 'Zeit') !== false || stripos($line, 'Verlust') !== false) {
        echo "   $line\n";
    }
}
echo "   " . ($ping_code === 0 ? "✅ Server erreichbar" : "❌ Server nicht erreichbar") . "\n\n";

// 5. Prüfe UNC-Pfad-Zugriff
echo "5. Prüfe UNC-Pfad-Zugriff...\n";
$unc_path = "\\\\$server_ip";
$unc_test_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { if (Test-Path \'%s\') { Write-Host \"✅ UNC-Pfad erreichbar\"; Get-ChildItem \'%s\' | Select-Object -First 5 Name | ForEach-Object { Write-Host \"  - $($_.Name)\" } } else { Write-Host \"❌ UNC-Pfad nicht erreichbar\" } } catch { Write-Host \"Fehler: $_\" }" 2>&1',
    $unc_path,
    $unc_path
);
exec($unc_test_cmd, $unc_test_output, $unc_test_code);
foreach ($unc_test_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 6. Prüfe Drucker-Freigabe auf Server
echo "6. Prüfe Drucker-Freigabe auf Server...\n";
$share_cmd = sprintf('net view "\\\\%s" 2>&1', $server_ip);
exec($share_cmd, $share_output, $share_code);
$printer_found = false;
foreach ($share_output as $line) {
    if (stripos($line, $printer_name) !== false || stripos($line, 'Drucker') !== false) {
        echo "   $line\n";
        $printer_found = true;
    }
}
if (!$printer_found) {
    echo "   ⚠️ Drucker nicht in Freigaben gefunden\n";
}
echo "\n";

// 7. Prüfe Drucker-Treiber
echo "7. Prüfe Drucker-Treiber...\n";
$driver_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $driver = Get-PrinterDriver -Name \'Bar Code Printer TTP068-50\' -ErrorAction Stop; Write-Host \"✅ Treiber gefunden: $($driver.Name)\"; Write-Host \"Version: $($driver.DriverVersion)\" } catch { Write-Host \"❌ Treiber nicht gefunden: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name)
);
exec($driver_cmd, $driver_output, $driver_code);
foreach ($driver_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 8. Empfehlungen
echo str_repeat("=", 60) . "\n";
echo "💡 EMPFEHLUNGEN:\n";
echo str_repeat("=", 60) . "\n\n";

echo "Da auch die Windows-Testseite nicht druckt, liegt das Problem wahrscheinlich:\n\n";

echo "1. Auf dem Drucker-Server:\n";
echo "   - Prüfe, ob der Drucker auf dem Server (100.82.207.72) läuft\n";
echo "   - Prüfe, ob der Drucker online ist\n";
echo "   - Prüfe, ob der Drucker-Papier hat\n";
echo "   - Prüfe, ob der Drucker Fehler anzeigt\n\n";

echo "2. Netzwerk-Verbindung:\n";
echo "   - Prüfe, ob der Server erreichbar ist (ping $server_ip)\n";
echo "   - Prüfe, ob die VPN-Verbindung (Tailscale) aktiv ist\n";
echo "   - Prüfe Firewall-Einstellungen\n\n";

echo "3. Windows-Berechtigungen:\n";
echo "   - Der Drucker-Port benötigt möglicherweise höhere Berechtigungen\n";
echo "   - Versuche, den Drucker als Administrator zu installieren\n";
echo "   - Prüfe Windows-Ereignisanzeige für detaillierte Fehler\n\n";

echo "4. Alternative Lösung:\n";
echo "   - Installiere den Drucker direkt auf dem Server (100.82.207.72)\n";
echo "   - Drucke von dort aus\n";
echo "   - Oder verwende einen lokalen TCP/IP-Port statt UNC-Port\n\n";

echo str_repeat("=", 60) . "\n";









