<?php
/**
 * Debug-Script für Feedback-Laden
 */

session_start();
require_once '../config/database.php';

// Prüfe ob Admin eingeloggt ist
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    die("Nicht eingeloggt");
}

$db = new Database();
$conn = $db->getConnection();

echo "<h1>Feedback Debug</h1>";

// Test 1: Prüfe ob Tabelle existiert
echo "<h2>Test 1: Tabelle existiert?</h2>";
try {
    $checkTable = $conn->query("SHOW TABLES LIKE 'feedback'");
    if ($checkTable->rowCount() > 0) {
        echo "✅ Tabelle 'feedback' existiert<br>";
    } else {
        echo "❌ Tabelle 'feedback' existiert NICHT<br>";
        exit;
    }
} catch (PDOException $e) {
    echo "❌ Fehler: " . $e->getMessage() . "<br>";
    exit;
}

// Test 2: Zähle Feedbacks
echo "<h2>Test 2: Anzahl Feedbacks</h2>";
try {
    $countStmt = $conn->query("SELECT COUNT(*) as count FROM feedback");
    $count = $countStmt->fetch(PDO::FETCH_ASSOC);
    echo "Anzahl Feedbacks in DB: <strong>" . $count['count'] . "</strong><br>";
} catch (PDOException $e) {
    echo "❌ Fehler: " . $e->getMessage() . "<br>";
}

// Test 3: Lade Feedbacks ohne JOINs
echo "<h2>Test 3: Feedbacks ohne JOINs</h2>";
try {
    $stmt = $conn->query("SELECT * FROM feedback ORDER BY created_at DESC LIMIT 10");
    $feedbacks = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo "Anzahl geladener Feedbacks: <strong>" . count($feedbacks) . "</strong><br><br>";
    
    if (count($feedbacks) > 0) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Rating</th><th>Text</th><th>Status</th><th>User ID</th><th>Autohaus ID</th><th>Erstellt</th></tr>";
        foreach ($feedbacks as $fb) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($fb['id']) . "</td>";
            echo "<td>" . htmlspecialchars($fb['rating']) . "</td>";
            echo "<td>" . htmlspecialchars(substr($fb['feedback_text'], 0, 50)) . "...</td>";
            echo "<td>" . htmlspecialchars($fb['status']) . "</td>";
            echo "<td>" . ($fb['user_id'] ? htmlspecialchars($fb['user_id']) : 'NULL') . "</td>";
            echo "<td>" . ($fb['autohaus_id'] ? htmlspecialchars($fb['autohaus_id']) : 'NULL') . "</td>";
            echo "<td>" . htmlspecialchars($fb['created_at']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
} catch (PDOException $e) {
    echo "❌ Fehler: " . $e->getMessage() . "<br>";
}

// Test 4: Lade Feedbacks mit JOINs
echo "<h2>Test 4: Feedbacks mit JOINs</h2>";
try {
    $stmt = $conn->prepare("
        SELECT f.*, 
               u.first_name, u.last_name, u.email,
               a.name as autohaus_name,
               admin.username as admin_response_by_name
        FROM feedback f
        LEFT JOIN users u ON f.user_id = u.id
        LEFT JOIN autohaus a ON f.autohaus_id = a.id
        LEFT JOIN admin_users admin ON f.admin_response_by = admin.id
        ORDER BY f.created_at DESC
        LIMIT 10
    ");
    $stmt->execute();
    $feedbacks = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo "Anzahl geladener Feedbacks: <strong>" . count($feedbacks) . "</strong><br><br>";
    
    if (count($feedbacks) > 0) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Rating</th><th>Text</th><th>Status</th><th>Name</th><th>Email</th><th>Autohaus</th></tr>";
        foreach ($feedbacks as $fb) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($fb['id']) . "</td>";
            echo "<td>" . htmlspecialchars($fb['rating']) . "</td>";
            echo "<td>" . htmlspecialchars(substr($fb['feedback_text'], 0, 50)) . "...</td>";
            echo "<td>" . htmlspecialchars($fb['status']) . "</td>";
            echo "<td>" . ($fb['first_name'] ? htmlspecialchars($fb['first_name'] . ' ' . $fb['last_name']) : 'Anonym') . "</td>";
            echo "<td>" . ($fb['email'] ? htmlspecialchars($fb['email']) : '-') . "</td>";
            echo "<td>" . ($fb['autohaus_name'] ? htmlspecialchars($fb['autohaus_name']) : '-') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
} catch (PDOException $e) {
    echo "❌ Fehler: " . $e->getMessage() . "<br>";
    echo "SQL Error Info: " . print_r($stmt->errorInfo(), true) . "<br>";
}

// Test 5: Aktueller Admin-User
echo "<h2>Test 5: Aktueller Admin-User</h2>";
$current_user_id = $_SESSION['admin_user_id'] ?? null;
$current_user_role = 'admin';
$current_user_autohaus_id = null;

if ($current_user_id) {
    try {
        $stmt = $conn->prepare("
            SELECT u.role, u.autohaus_id, u.username
            FROM admin_users u
            WHERE u.id = ?
        ");
        $stmt->execute([$current_user_id]);
        $user_data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($user_data) {
            $current_user_role = $user_data['role'] ?? 'admin';
            $current_user_autohaus_id = $user_data['autohaus_id'];
            echo "User ID: <strong>" . $current_user_id . "</strong><br>";
            echo "Role: <strong>" . $current_user_role . "</strong><br>";
            echo "Autohaus ID: <strong>" . ($current_user_autohaus_id ? $current_user_autohaus_id : 'NULL') . "</strong><br>";
        }
    } catch (PDOException $e) {
        echo "❌ Fehler: " . $e->getMessage() . "<br>";
    }
} else {
    echo "Keine User ID in Session<br>";
}

// Test 6: Filter-Test
echo "<h2>Test 6: Filter-Test (wie in feedback.php)</h2>";
$filter_status = 'all';
$where_conditions = [];
$params = [];

$where_clause = !empty($where_conditions) ? "WHERE " . implode(" AND ", $where_conditions) : "";

if ($current_user_autohaus_id && $current_user_role !== 'super_admin') {
    $where_conditions[] = "f.autohaus_id = ?";
    $params[] = $current_user_autohaus_id;
    $where_clause = "WHERE " . implode(" AND ", $where_conditions);
}

try {
    $sql = "
        SELECT f.*, 
               u.first_name, u.last_name, u.email,
               a.name as autohaus_name,
               admin.username as admin_response_by_name
        FROM feedback f
        LEFT JOIN users u ON f.user_id = u.id
        LEFT JOIN autohaus a ON f.autohaus_id = a.id
        LEFT JOIN admin_users admin ON f.admin_response_by = admin.id
        $where_clause
        ORDER BY f.created_at DESC
        LIMIT 100
    ";
    
    echo "SQL Query:<br><pre>" . htmlspecialchars($sql) . "</pre><br>";
    echo "Params: <pre>" . print_r($params, true) . "</pre><br>";
    
    $stmt = $conn->prepare($sql);
    $stmt->execute($params);
    $feedback_list = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Anzahl geladener Feedbacks: <strong>" . count($feedback_list) . "</strong><br>";
    
} catch (PDOException $e) {
    echo "❌ Fehler: " . $e->getMessage() . "<br>";
    echo "SQL Error Info: " . print_r($stmt->errorInfo(), true) . "<br>";
}

?>









