<?php
/**
 * Debug: Prüfe API-Key-Ladung für ein Autohaus
 */

session_start();
require_once '../config/database.php';
require_once 'includes/hellomateo_api.php';

header('Content-Type: application/json');

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    echo json_encode(['success' => false, 'error' => 'Nicht authentifiziert']);
    exit;
}

$autohausId = $_GET['autohaus_id'] ?? null;

if (!$autohausId) {
    echo json_encode(['success' => false, 'error' => 'Autohaus-ID erforderlich']);
    exit;
}

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // 1. Prüfe ob API-Key in Datenbank existiert
    $stmt = $conn->prepare("SELECT id, name, whatsapp_api_key FROM autohaus WHERE id = ?");
    $stmt->execute([$autohausId]);
    $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$autohaus) {
        echo json_encode(['success' => false, 'error' => 'Autohaus nicht gefunden']);
        exit;
    }
    
    $debug = [
        'autohaus_id' => $autohausId,
        'autohaus_name' => $autohaus['name'],
        'has_api_key_in_db' => !empty($autohaus['whatsapp_api_key']),
        'api_key_length' => strlen($autohaus['whatsapp_api_key'] ?? ''),
        'api_key_prefix' => substr($autohaus['whatsapp_api_key'] ?? '', 0, 30) . '...',
        'api_key_suffix' => '...' . substr($autohaus['whatsapp_api_key'] ?? '', -20),
    ];
    
    // 2. Prüfe ob HelloMateoAPI den Key lädt
    $hellomateo = new HelloMateoAPI(null, $autohausId);
    $apiKeyInfo = $hellomateo->getApiKeyInfo();
    
    $debug['api_key_info'] = $apiKeyInfo;
    
    // 3. Teste Verbindung
    $testResult = $hellomateo->testConnection();
    $debug['connection_test'] = $testResult;
    
    // 4. Versuche Templates zu laden
    $templatesResult = $hellomateo->listTemplates(10, 0);
    $debug['templates_test'] = [
        'success' => $templatesResult['success'],
        'error' => $templatesResult['error'] ?? null,
        'http_code' => $templatesResult['http_code'] ?? null,
        'has_data' => !empty($templatesResult['data']),
        'data_count' => is_array($templatesResult['data']) ? count($templatesResult['data']) : 0
    ];
    
    echo json_encode([
        'success' => true,
        'debug' => $debug
    ], JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'trace' => $e->getTraceAsString()
    ], JSON_PRETTY_PRINT);
}




