<?php
/**
 * Verbindet PRT17 von 100.82.207.72
 * WICHTIG: PRT17 muss zuerst auf dem Server als Netzwerkdrucker freigegeben werden!
 */

require_once __DIR__ . '/../config/printer.php';

echo "🔌 PRT17 Verbindung\n";
echo str_repeat("=", 60) . "\n\n";

$printer_name_server = 'BUEK-PRT17'; // Name auf dem Server (Freigabename)
$printer_name_local = 'BUEK-PRT17'; // Name nach lokaler Installation
$server_ip = PRINTER_SERVER_TAILSCALE_IP;
$server_user = PRINTER_SERVER_USER;
$server_pass = PRINTER_SERVER_PASS;

echo "Drucker auf Server: $printer_name_server\n";
echo "Lokaler Name (nach Installation): $printer_name_local\n";
echo "Server: $server_ip\n";
echo "Benutzer: $server_user\n\n";

// 1. Prüfe, ob PRT17 auf dem Server freigegeben ist
echo "1. Prüfe, ob PRT17 auf dem Server freigegeben ist...\n";
$net_view_cmd = sprintf('net view "\\\\%s" 2>&1', $server_ip);
exec($net_view_cmd, $net_view_output, $net_view_code);
$prt17_found = false;
foreach ($net_view_output as $line) {
    if (stripos($line, 'PRT17') !== false && stripos($line, 'Drucker') !== false) {
        echo "   ✅ PRT17 gefunden: $line\n";
        $prt17_found = true;
        // Extrahiere den genauen Namen
        preg_match('/^([^\s]+)\s+Drucker/', $line, $matches);
        if (isset($matches[1])) {
            $printer_name_server = trim($matches[1]);
            echo "   ✅ Genauer Name: $printer_name_server\n";
        }
        break;
    }
}

if (!$prt17_found) {
    echo "   ❌ PRT17 NICHT GEFUNDEN!\n\n";
    echo "   ⚠️⚠️⚠️ WICHTIG: PRT17 muss zuerst auf dem Server freigegeben werden!\n\n";
    echo "   Siehe: admin/PRT17_FREIGABE_ANLEITUNG.md\n\n";
    echo "   Nach der Freigabe bitte erneut ausführen:\n";
    echo "     php admin/connect_prt17.php\n\n";
    exit(1);
}
echo "\n";

// 2. Stelle net use Verbindung her
echo "2. Stelle net use Verbindung her...\n";
$net_use_cmd = sprintf(
    'net use "\\\\%s" %s /user:%s /persistent:yes 2>&1',
    $server_ip,
    $server_pass ? escapeshellarg($server_pass) : '',
    escapeshellarg($server_user)
);
exec($net_use_cmd, $net_use_output, $net_use_code);
foreach ($net_use_output as $line) {
    if (trim($line)) {
        echo "   $line\n";
    }
}
echo "\n";

// 3. Prüfe, ob PRT17 bereits lokal installiert ist
echo "3. Prüfe, ob PRT17 bereits lokal installiert ist...\n";
$check_cmd = 'wmic printer get name 2>&1';
exec($check_cmd, $check_output, $check_code);
$already_installed = false;
foreach ($check_output as $line) {
    $line_trimmed = trim($line);
    if (stripos($line_trimmed, 'PRT17') !== false || 
        (stripos($line_trimmed, 'BUEK') !== false && stripos($line_trimmed, 'PRT') !== false)) {
        echo "   ⚠️ Drucker bereits gefunden: $line_trimmed\n";
        $already_installed = true;
        $printer_name_local = $line_trimmed;
    }
}
if (!$already_installed) {
    echo "   ✅ PRT17 noch nicht installiert\n";
}
echo "\n";

// 4. Lösche alten Drucker (falls vorhanden)
if ($already_installed) {
    echo "4. Lösche alten Drucker...\n";
    $delete_cmd = sprintf('rundll32 printui.dll,PrintUIEntry /dl /n "%s" 2>&1', $printer_name_local);
    exec($delete_cmd, $delete_output, $delete_code);
    sleep(2);
    echo "\n";
}

// 5. Öffne Windows Explorer für manuelle Verbindung
echo "5. Öffne Windows Explorer für manuelle Verbindung...\n";
$explorer_cmd = sprintf('explorer "\\\\%s"', $server_ip);
exec($explorer_cmd);
echo "   ✅ Windows Explorer geöffnet\n";
echo "\n";

echo str_repeat("=", 60) . "\n";
echo "📋 WICHTIGE ANLEITUNG FÜR MANUELLE VERBINDUNG:\n";
echo str_repeat("=", 60) . "\n\n";

echo "⚠️⚠️⚠️ DIESER SCHRITT IST ZWINGEND ERFORDERLICH! ⚠️⚠️⚠️\n\n";

echo "1. Im geöffneten Windows Explorer sollte '$printer_name_server' sichtbar sein\n";
echo "   (Das ist der Drucker mit dem Drucker-Icon)\n\n";

echo "2. Rechtsklick auf '$printer_name_server'\n\n";

echo "3. Wähle 'Drucker verbinden' oder 'Connect'\n\n";

echo "4. Wenn nach Credentials gefragt wird:\n";
echo "   Benutzer: $server_user\n";
echo "   Passwort: $server_pass\n";
echo "   ☑️☑️☑️ 'Anmeldedaten speichern' MUSS aktiviert sein! ☑️☑️☑️\n\n";

echo "5. Warte, bis die Installation abgeschlossen ist\n\n";

echo "6. Prüfe in Windows-Einstellungen → Drucker:\n";
echo "   - Der Drucker sollte als '$printer_name_local' erscheinen\n";
echo "   - Status sollte 'Bereit' oder 'Normal' sein (NICHT 'Fehler'!)\n\n";

echo "7. Teste Windows-Testseite:\n";
echo "   - Rechtsklick auf Drucker → 'Druckereigenschaften'\n";
echo "   - 'Testseite drucken'\n";
echo "   - Falls erfolgreich: ✅ Drucker funktioniert!\n\n";

echo str_repeat("=", 60) . "\n";
echo "🔍 NACH DER VERBINDUNG:\n";
echo str_repeat("=", 60) . "\n\n";

echo "Führen Sie aus:\n";
echo "  php admin/verify_prt17_connection.php\n\n";

