<?php
/**
 * Verbindet "labelprinter service" von 100.82.207.72
 * Dieser Drucker MUSS manuell verbunden werden, damit er funktioniert!
 */

require_once __DIR__ . '/../config/printer.php';

echo "🔌 labelprinter service Verbindung\n";
echo str_repeat("=", 60) . "\n\n";

$printer_name_server = 'labelprinter service'; // Name auf dem Server (wie in Windows Explorer)
$printer_name_local = 'LABELPRINTER SERVICE'; // Name nach lokaler Installation
$server_ip = PRINTER_SERVER_TAILSCALE_IP;
$server_user = PRINTER_SERVER_USER;
$server_pass = PRINTER_SERVER_PASS;

echo "Drucker auf Server: $printer_name_server\n";
echo "Lokaler Name (nach Installation): $printer_name_local\n";
echo "Server: $server_ip\n";
echo "Benutzer: $server_user\n\n";

// 1. Stelle net use Verbindung her
echo "1. Stelle net use Verbindung her...\n";
$net_use_cmd = sprintf(
    'net use "\\\\%s" %s /user:%s /persistent:yes 2>&1',
    $server_ip,
    $server_pass ? escapeshellarg($server_pass) : '',
    escapeshellarg($server_user)
);
exec($net_use_cmd, $net_use_output, $net_use_code);
foreach ($net_use_output as $line) {
    echo "   $line\n";
}
$net_use_success = ($net_use_code === 0);
echo "   " . ($net_use_success ? "✅ Erfolgreich" : "❌ Fehlgeschlagen") . "\n\n";

// 2. Prüfe, ob Drucker bereits installiert ist
echo "2. Prüfe vorhandene Drucker...\n";
$check_cmd = 'wmic printer get name 2>&1';
exec($check_cmd, $check_output, $check_code);
$already_installed = false;
$installed_name = '';
foreach ($check_output as $line) {
    $line_trimmed = trim($line);
    if (stripos($line_trimmed, 'LABELPRINTER') !== false || 
        stripos($line_trimmed, 'LABEL') !== false) {
        echo "   ⚠️ Drucker gefunden: $line_trimmed\n";
        $already_installed = true;
        $installed_name = $line_trimmed;
    }
}
if (!$already_installed) {
    echo "   ✅ Drucker noch nicht installiert\n";
}
echo "\n";

// 3. Öffne Windows Explorer für manuelle Verbindung
echo "3. Öffne Windows Explorer für manuelle Verbindung...\n";
$explorer_cmd = sprintf('explorer "\\\\%s"', $server_ip);
exec($explorer_cmd);
echo "   ✅ Windows Explorer geöffnet\n";
echo "\n";

echo str_repeat("=", 60) . "\n";
echo "📋 WICHTIGE ANLEITUNG FÜR MANUELLE VERBINDUNG:\n";
echo str_repeat("=", 60) . "\n\n";

echo "⚠️⚠️⚠️ DIESER SCHRITT IST ZWINGEND ERFORDERLICH! ⚠️⚠️⚠️\n\n";

echo "1. Im geöffneten Windows Explorer sollte '$printer_name_server' sichtbar sein\n";
echo "   (Das ist der Drucker mit dem Drucker-Icon)\n\n";

echo "2. Rechtsklick auf '$printer_name_server'\n\n";

echo "3. Wähle 'Drucker verbinden' oder 'Connect'\n\n";

echo "4. Wenn nach Credentials gefragt wird:\n";
echo "   Benutzer: $server_user\n";
echo "   Passwort: $server_pass\n";
echo "   ☑️ 'Anmeldedaten speichern' aktivieren\n\n";

echo "5. Warte, bis die Installation abgeschlossen ist\n";
echo "   (Es erscheint eine Meldung wie 'Drucker wird hinzugefügt...')\n\n";

echo "6. Prüfe in Windows-Einstellungen → Drucker:\n";
echo "   - Der Drucker sollte als '$printer_name_local' erscheinen\n";
echo "   - Status sollte 'Bereit' oder 'Normal' sein\n\n";

echo "7. Teste Windows-Testseite:\n";
echo "   - Rechtsklick auf Drucker → 'Druckereigenschaften'\n";
echo "   - 'Testseite drucken'\n";
echo "   - Falls erfolgreich: ✅ Drucker funktioniert!\n\n";

echo str_repeat("=", 60) . "\n";
echo "💡 WARUM MANUELL?\n";
echo str_repeat("=", 60) . "\n\n";

echo "Windows speichert die Authentifizierung für UNC-Drucker-Ports nur,\n";
echo "wenn der Drucker über Windows Explorer verbunden wird.\n\n";

echo "Automatische Installation über PowerShell/rundll32 funktioniert zwar,\n";
echo "aber Windows speichert die Credentials nicht korrekt, sodass der\n";
echo "Drucker-Port nicht initialisiert werden kann.\n\n";

echo "Nach manueller Verbindung über Windows Explorer:\n";
echo "✅ Windows speichert die Authentifizierung korrekt\n";
echo "✅ Der Drucker-Port kann initialisiert werden\n";
echo "✅ Die API kann erfolgreich drucken\n\n";

echo str_repeat("=", 60) . "\n";
echo "🔍 NACH DER INSTALLATION - PRÜFUNG:\n";
echo str_repeat("=", 60) . "\n\n";

echo "Führen Sie nach der manuellen Verbindung aus:\n";
echo "  php admin/verify_printer_connection.php\n\n";

echo "Dieses Script prüft, ob der Drucker korrekt installiert ist und\n";
echo "ob ein Test-Druck funktioniert.\n\n";









