<?php
/**
 * Lösche fehlerhafte Druckaufträge und bereite Drucker für manuelle Verbindung vor
 */

require_once __DIR__ . '/../config/printer.php';

echo "🧹 Drucker bereinigen und vorbereiten\n";
echo str_repeat("=", 60) . "\n\n";

$printer_name = 'LABELPRINTER SERVICE';
$server_ip = PRINTER_SERVER_TAILSCALE_IP;

// 1. Lösche alle Druckaufträge
echo "1. Lösche alle Druckaufträge...\n";
$clear_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $jobs = Get-PrintJob -PrinterName \'%s\' -ErrorAction SilentlyContinue; foreach ($job in $jobs) { Remove-PrintJob -PrinterName \'%s\' -ID $job.Id -ErrorAction SilentlyContinue; Write-Host \"Gelöscht: $($job.Name)\" } } catch { }" 2>&1',
    str_replace("'", "''", $printer_name),
    str_replace("'", "''", $printer_name)
);
exec($clear_cmd, $clear_output, $clear_code);
foreach ($clear_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 2. Stelle net use Verbindung her
echo "2. Stelle net use Verbindung her...\n";
$net_use_cmd = sprintf(
    'net use "\\\\%s" %s /user:%s 2>&1',
    $server_ip,
    PRINTER_SERVER_PASS ? escapeshellarg(PRINTER_SERVER_PASS) : '',
    escapeshellarg(PRINTER_SERVER_USER)
);
exec($net_use_cmd, $net_use_output, $net_use_code);
foreach ($net_use_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 3. Öffne Windows Explorer zum manuellen Verbinden
echo "3. Öffne Windows Explorer für manuelle Verbindung...\n";
$explorer_cmd = sprintf('explorer "\\\\%s"', $server_ip);
exec($explorer_cmd);
echo "   ✅ Windows Explorer geöffnet\n";
echo "\n";

echo str_repeat("=", 60) . "\n";
echo "📋 ANLEITUNG FÜR MANUELLE VERBINDUNG:\n";
echo str_repeat("=", 60) . "\n\n";

echo "1. Im geöffneten Windows Explorer sollte der Drucker '$printer_name' sichtbar sein\n";
echo "2. Rechtsklick auf '$printer_name'\n";
echo "3. Wähle 'Drucker verbinden' oder 'Connect'\n";
echo "4. Wenn nach Credentials gefragt wird:\n";
echo "   Benutzer: " . PRINTER_SERVER_USER . "\n";
echo "   Passwort: [Ihr Passwort]\n";
echo "5. Warte, bis die Verbindung hergestellt ist\n";
echo "6. Versuche dann erneut, die Windows-Testseite zu drucken\n";
echo "\n";

echo "💡 WARUM MANUELL?\n";
echo "Windows speichert die Authentifizierung für Drucker-Ports nur, wenn der\n";
echo "Drucker über Windows Explorer verbunden wird. Automatische Installation\n";
echo "über PowerShell/rundll32 speichert die Credentials nicht korrekt.\n";
echo "\n";

echo str_repeat("=", 60) . "\n";









