<?php
require_once __DIR__ . '/../config/database.php';

$db = new Database();
$conn = $db->getConnection();

// Setze API-Key
$apiKey = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ0aWQiIDogIjE3OTNiZTE1LWFiNjEtNDQ1Yy04M2UyLTkwN2MyZjAzOTE2ZCIsICJuYW1lIiA6ICJURVNUIEFQSSIsICJpc3MiIDogInN1cGFiYXNlIiwgInN1YiIgOiAiNzFlMGQ3YzgtOGQ1Yy00NWIxLWExNTItMmMzZDhlYjg5ZjhhIiwgInJvbGUiIDogInRva2VuYXV0aGVkIiwgImlhdCIgOiAxNzY1MzU3NjgzLjY5NTY1NH0.ZPiqgyAogPelxc1rJ1aLMMURT14-rotI94FRPBqlDiU';

echo "=== API-Key Check ===\n";
echo "API-Key Länge: " . strlen($apiKey) . "\n";
echo "API-Key Präfix: " . substr($apiKey, 0, 50) . "...\n\n";

// Hole alle Autohäuser
$stmt = $conn->query("SELECT id, name, whatsapp_api_key FROM autohaus LIMIT 5");
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "Autohäuser in Datenbank:\n";
foreach ($results as $row) {
    $keyLength = strlen($row['whatsapp_api_key'] ?? '');
    $keyPrefix = substr($row['whatsapp_api_key'] ?? '', 0, 30);
    echo "  ID: {$row['id']}, Name: {$row['name']}, API-Key Länge: {$keyLength}, Präfix: {$keyPrefix}...\n";
}

// Setze API-Key für erstes Autohaus
$autohausId = $results[0]['id'] ?? 1;
echo "\nSetze API-Key für Autohaus ID: {$autohausId}\n";
$stmt = $conn->prepare("UPDATE autohaus SET whatsapp_api_key = ? WHERE id = ?");
$stmt->execute([$apiKey, $autohausId]);

// Prüfe ob gespeichert wurde
$stmt = $conn->prepare("SELECT whatsapp_api_key FROM autohaus WHERE id = ?");
$stmt->execute([$autohausId]);
$result = $stmt->fetch(PDO::FETCH_ASSOC);

echo "\nNach Update:\n";
echo "  API-Key Länge: " . strlen($result['whatsapp_api_key'] ?? '') . "\n";
echo "  API-Key Präfix: " . substr($result['whatsapp_api_key'] ?? '', 0, 50) . "...\n";
echo "  API-Key Suffix: ..." . substr($result['whatsapp_api_key'] ?? '', -30) . "\n";
echo "  API-Key vollständig: " . ($result['whatsapp_api_key'] ?? 'NULL') . "\n";

// Prüfe ob gleich
if (($result['whatsapp_api_key'] ?? '') === $apiKey) {
    echo "\n✅ API-Key wurde korrekt gespeichert!\n";
} else {
    echo "\n❌ API-Key stimmt nicht überein!\n";
    echo "  Erwartet: " . substr($apiKey, 0, 50) . "...\n";
    echo "  Gefunden: " . substr($result['whatsapp_api_key'] ?? '', 0, 50) . "...\n";
}





