<?php
session_start();
require_once '../config/database.php';
require_once 'includes/helpers.php';

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header('Location: login.php');
    exit;
}

$db = new Database();
$conn = $db->getConnection();
?>
<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>API Manager - Admin</title>
  <link rel="stylesheet" href="../assets/css/style.css">
  <link rel="stylesheet" href="assets/css/admin.css">
  <link rel="stylesheet" href="<?php echo asset_url('assets/css/unified-sidebar.css'); ?>">
  <link rel="stylesheet" href="assets/css/simple-sidebar.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    /* Admin Main - Sidebar Margin */
    .admin-main {
      margin-left: 300px !important;
      transition: margin-left 0.3s ease;
    }

    .smart-sidebar.collapsed + .admin-main {
      margin-left: 80px !important;
    }
  </style>
</head>
<body>
  <div class="admin-container">
    <?php include 'includes/sidebar.php'; ?>
    <main class="admin-main">
      <header class="admin-header">
        <div class="header-content">
          <h1><i class="fas fa-shield-halved"></i> API Manager</h1>
          <div>
            <button type="button" class="btn btn-secondary" onclick="openReauth()"><i class="fas fa-lock"></i> Re-Auth</button>
            <button type="button" class="btn btn-primary" onclick="openCreateKey()"><i class="fas fa-key"></i> Key anlegen</button>
          </div>
        </div>
      </header>

      <div class="admin-content">
        <section class="content-card" style="margin-bottom: 1.5rem;">
          <div class="card-header"><h3>API Keys</h3></div>
          <div class="card-content">
            <div id="keys-list">Wird geladen…</div>
          </div>
        </section>

        <section class="content-card">
          <div class="card-header"><h3>Nutzung & Monitoring</h3></div>
          <div class="card-content">
            <div id="usage-recent">Wird geladen…</div>
            <hr>
            <div id="usage-stats">Wird geladen…</div>
          </div>
        </section>
      </div>
    </main>
  </div>

  <!-- Re-Auth Modal (schützt sensible Aktionen) -->
  <div id="reauth-modal" class="modal-backdrop hidden">
    <div class="modal-content">
      <div class="modal-header">
        <h3><i class="fas fa-lock"></i> Re-Authentifizierung</h3>
        <button class="modal-close" onclick="closeReauth()">&times;</button>
      </div>
      <div class="modal-body">
        <p>Bitte Admin-Passwort eingeben, um fortzufahren.</p>
        <input type="password" id="reauth-password" placeholder="Passwort" style="width:100%;padding:10px;">
        <div class="modal-actions" style="margin-top:1rem;">
          <button type="button" class="btn btn-secondary" onclick="closeReauth()">Abbrechen</button>
          <button type="button" class="btn btn-primary" onclick="confirmReauth()">Bestätigen</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Create Key Modal -->
  <div id="create-key-modal" class="modal-backdrop hidden">
    <div class="modal-content">
      <div class="modal-header">
        <h3><i class="fas fa-key"></i> Neuen API Key erstellen</h3>
        <button class="modal-close" onclick="closeCreateKey()">&times;</button>
      </div>
      <div class="modal-body">
        <label>Name</label>
        <input type="text" id="key-name" placeholder="mobile-app" style="width:100%;padding:10px;">

        <div style="margin-top:10px;">
          <label>Scopes (einfach auswählen)</label>
          <div style="display:grid;grid-template-columns:1fr 1fr;gap:8px;margin-top:6px;">
            <label><input type="checkbox" class="scope-checkbox" value="slots:read"> Slots lesen</label>
            <label><input type="checkbox" class="scope-checkbox" value="appointments:write"> Termine buchen/ändern</label>
            <label><input type="checkbox" class="scope-checkbox" value="profile:read"> Profil lesen</label>
            <label><input type="checkbox" class="scope-checkbox" value="profile:write"> Profil ändern</label>
            <label><input type="checkbox" class="scope-checkbox" value="vehicles:read"> Fahrzeuge lesen</label>
            <label><input type="checkbox" class="scope-checkbox" value="vehicles:write"> Fahrzeuge ändern</label>
            <label><input type="checkbox" class="scope-checkbox" value="notifications:read"> Benachrichtigungen lesen</label>
            <label><input type="checkbox" class="scope-checkbox" value="notifications:write"> Benachrichtigungen ändern</label>
            <label><input type="checkbox" class="scope-checkbox" value="activity:read"> Aktivitäten lesen</label>
            <label><input type="checkbox" class="scope-checkbox" value="documents:upload"> Dokumente hochladen</label>
          </div>
          <details style="margin-top:8px;">
            <summary>Erweiterte Admin-Scopes</summary>
            <div style="display:grid;grid-template-columns:1fr 1fr;gap:8px;margin-top:6px;">
              <label><input type="checkbox" class="scope-checkbox" value="admin:verify"> Verifizierung (Approve/Reject)</label>
              <label><input type="checkbox" class="scope-checkbox" value="admin:link"> Kunden ↔ Admin verknüpfen</label>
              <label><input type="checkbox" class="scope-checkbox" value="admin:customers:read"> Kundenprofile lesen</label>
              <label><input type="checkbox" class="scope-checkbox" value="admin:settings:write"> Einstellungen ändern</label>
              <label><input type="checkbox" class="scope-checkbox" value="admin:api_keys"> API Keys verwalten</label>
              <label><input type="checkbox" class="scope-checkbox" value="admin:documents"> Dokumente verwalten</label>
              <label><input type="checkbox" class="scope-checkbox" value="admin:users:read"> Admin-Benutzer lesen</label>
              <label><input type="checkbox" class="scope-checkbox" value="admin:users:write"> Admin-Benutzer ändern</label>
              <label><input type="checkbox" class="scope-checkbox" value="admin:offers:read"> Angebote lesen</label>
              <label><input type="checkbox" class="scope-checkbox" value="admin:offers:write"> Angebote ändern</label>
            </div>
          </details>
          <details style="margin-top:8px;">
            <summary>JSON-Eingabe (optional)</summary>
            <textarea id="key-scopes" rows="3" placeholder='["slots:read","appointments:write"]' style="width:100%;padding:10px;"></textarea>
            <small>Wenn hier JSON eingetragen ist, überschreibt es die Checkbox-Auswahl.</small>
          </details>
        </div>

        <label style="margin-top:10px;">Rate Limit / min</label>
        <input type="number" id="key-rate" value="120" style="width:100%;padding:10px;">
        <div class="modal-actions" style="margin-top:1rem;">
          <button type="button" class="btn btn-secondary" onclick="closeCreateKey()">Abbrechen</button>
          <button type="button" class="btn btn-primary" onclick="submitCreateKey()">Erstellen</button>
        </div>
        <div id="create-result" style="margin-top:1rem;color:#dc3545;display:none;"></div>
      </div>
    </div>
  </div>

  <!-- Edit Key Modal -->
  <div id="edit-key-modal" class="modal-backdrop hidden">
    <div class="modal-content">
      <div class="modal-header">
        <h3><i class="fas fa-pen"></i> API Key bearbeiten</h3>
        <button class="modal-close" onclick="closeEditKey()">&times;</button>
      </div>
      <div class="modal-body">
        <input type="hidden" id="edit-key-id">
        <label>Name</label>
        <input type="text" id="edit-key-name" style="width:100%;padding:10px;">
        <div style="margin-top:10px;">
          <label>Scopes</label>
          <div style="display:grid;grid-template-columns:1fr 1fr;gap:8px;margin-top:6px;">
            <label><input type="checkbox" class="scope-checkbox-edit" value="slots:read"> Slots lesen</label>
            <label><input type="checkbox" class="scope-checkbox-edit" value="appointments:write"> Termine buchen/ändern</label>
            <label><input type="checkbox" class="scope-checkbox-edit" value="profile:read"> Profil lesen</label>
            <label><input type="checkbox" class="scope-checkbox-edit" value="profile:write"> Profil ändern</label>
            <label><input type="checkbox" class="scope-checkbox-edit" value="vehicles:read"> Fahrzeuge lesen</label>
            <label><input type="checkbox" class="scope-checkbox-edit" value="vehicles:write"> Fahrzeuge ändern</label>
            <label><input type="checkbox" class="scope-checkbox-edit" value="notifications:read"> Benachrichtigungen lesen</label>
            <label><input type="checkbox" class="scope-checkbox-edit" value="notifications:write"> Benachrichtigungen ändern</label>
            <label><input type="checkbox" class="scope-checkbox-edit" value="activity:read"> Aktivitäten lesen</label>
            <label><input type="checkbox" class="scope-checkbox-edit" value="documents:upload"> Dokumente hochladen</label>
          </div>
          <details style="margin-top:8px;">
            <summary>Erweiterte Admin-Scopes</summary>
            <div style="display:grid;grid-template-columns:1fr 1fr;gap:8px;margin-top:6px;">
              <label><input type="checkbox" class="scope-checkbox-edit" value="admin:verify"> Verifizierung</label>
              <label><input type="checkbox" class="scope-checkbox-edit" value="admin:link"> Kunden ↔ Admin verknüpfen</label>
              <label><input type="checkbox" class="scope-checkbox-edit" value="admin:customers:read"> Kundenprofile lesen</label>
              <label><input type="checkbox" class="scope-checkbox-edit" value="admin:settings:write"> Einstellungen ändern</label>
              <label><input type="checkbox" class="scope-checkbox-edit" value="admin:api_keys"> API Keys verwalten</label>
              <label><input type="checkbox" class="scope-checkbox-edit" value="admin:documents"> Dokumente verwalten</label>
              <label><input type="checkbox" class="scope-checkbox-edit" value="admin:users:read"> Admin-Benutzer lesen</label>
              <label><input type="checkbox" class="scope-checkbox-edit" value="admin:users:write"> Admin-Benutzer ändern</label>
              <label><input type="checkbox" class="scope-checkbox-edit" value="admin:offers:read"> Angebote lesen</label>
              <label><input type="checkbox" class="scope-checkbox-edit" value="admin:offers:write"> Angebote ändern</label>
            </div>
          </details>
          <details style="margin-top:8px;">
            <summary>JSON-Eingabe (optional)</summary>
            <textarea id="edit-key-scopes-json" rows="3" placeholder='["slots:read"]' style="width:100%;padding:10px;"></textarea>
          </details>
        </div>
        <div style="display:grid;grid-template-columns:1fr 1fr;gap:8px;margin-top:10px;">
          <div>
            <label>Rate Limit / min</label>
            <input type="number" id="edit-key-rate" value="60" style="width:100%;padding:10px;">
          </div>
          <div style="display:flex;align-items:flex-end;">
            <label style="display:flex;align-items:center;gap:8px;"><input type="checkbox" id="edit-key-active"> Aktiv</label>
          </div>
        </div>
        <div class="modal-actions" style="margin-top:1rem;">
          <button type="button" class="btn btn-secondary" onclick="closeEditKey()">Abbrechen</button>
          <button type="button" class="btn btn-primary" onclick="submitEditKey()">Speichern</button>
        </div>
        <div id="edit-result" style="margin-top:1rem;color:#dc3545;display:none;"></div>
      </div>
    </div>
  </div>

  <!-- Deactivate Key Modal -->
  <div id="deactivate-key-modal" class="modal-backdrop hidden">
    <div class="modal-content">
      <div class="modal-header">
        <h3><i class="fas fa-ban"></i> API Key deaktivieren</h3>
        <button class="modal-close" onclick="closeDeactivateKey()">&times;</button>
      </div>
      <div class="modal-body">
        <input type="hidden" id="deactivate-key-id">
        <p>Soll dieser API Key wirklich deaktiviert werden? Anwendungen mit diesem Key verlieren sofort den Zugriff.</p>
        <div class="modal-actions" style="margin-top:1rem;">
          <button type="button" class="btn btn-secondary" onclick="closeDeactivateKey()">Abbrechen</button>
          <button type="button" class="btn btn-danger" onclick="confirmDeactivateKey()">Deaktivieren</button>
        </div>
        <div id="deactivate-result" style="margin-top:1rem;color:#dc3545;display:none;"></div>
      </div>
    </div>
  </div>

  <script>
    function openReauth(){ const m=document.getElementById('reauth-modal'); m.classList.remove('hidden'); m.style.display='flex'; }
    function closeReauth(){ const m=document.getElementById('reauth-modal'); m.classList.add('hidden'); m.style.display='none'; }
    function confirmReauth(){
      const pw = (document.getElementById('reauth-password').value || '').trim();
      if(!pw){ alert('Bitte Passwort eingeben.'); return; }
      fetch('api/reauth.php', { method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({ password: pw }) })
        .then(r=>r.json())
        .then(d=>{
          if(d && d.success){
            alert('Re-Authentifizierung erfolgreich.');
            closeReauth();
          } else {
            alert(d.message || 'Re-Auth fehlgeschlagen');
          }
        })
        .catch(e=> alert('Re-Auth Fehler: '+e.message));
    }

    function openCreateKey(){ const m=document.getElementById('create-key-modal'); m.classList.remove('hidden'); m.style.display='flex'; document.getElementById('create-result').style.display='none'; }
    function closeCreateKey(){ const m=document.getElementById('create-key-modal'); m.classList.add('hidden'); m.style.display='none'; }

    let keysCache = [];
    function loadKeys(){
      fetch('api/api_keys.php').then(r=>r.json()).then(d=>{
        if(!d.success){ document.getElementById('keys-list').textContent=d.message||'Fehler'; return; }
        keysCache = d.keys || [];
        const wrap = document.createElement('div');
        keysCache.forEach((k,idx)=>{
          const row = document.createElement('div');
          row.style.cssText='display:flex;justify-content:space-between;align-items:center;border:1px solid #e0e0e0;border-radius:8px;padding:10px;margin-bottom:10px;';
          row.innerHTML = `
            <div>
              <strong>${k.name}</strong><br>
              <small>Scopes: ${k.scopes}</small><br>
              <small>Status: ${k.is_active? 'Aktiv':'Inaktiv'} | Rate: ${k.rate_limit_per_min}/min</small>
            </div>
            <div style="display:flex;gap:8px;">
              <button class="btn btn-secondary btn-sm" onclick='openEditKey(${idx})'><i class="fas fa-pen"></i></button>
              <button class="btn btn-danger btn-sm" onclick='openDeactivateKey(${k.id})'><i class="fas fa-ban"></i></button>
            </div>
          `;
          wrap.appendChild(row);
        });
        document.getElementById('keys-list').innerHTML='';
        document.getElementById('keys-list').appendChild(wrap);
      }).catch(e=>{ document.getElementById('keys-list').textContent=e.message; });
    }

    function submitCreateKey(){
      const name = document.getElementById('key-name').value.trim();
      const scopesTxt = (document.getElementById('key-scopes')?.value || '').trim();
      const rate = parseInt(document.getElementById('key-rate').value || '60',10);
      let scopes = [];
      if(scopesTxt){
        try{ scopes = JSON.parse(scopesTxt);}catch(e){ const m=document.getElementById('create-result'); m.style.display='block'; m.style.color='#dc3545'; m.textContent='Ungültiges Scopes JSON'; return; }
      } else {
        scopes = Array.from(document.querySelectorAll('.scope-checkbox:checked')).map(x=>x.value);
      }
      if(!name){ const m=document.getElementById('create-result'); m.style.display='block'; m.style.color='#dc3545'; m.textContent='Name ist erforderlich'; return; }

      fetch('api/api_keys.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({name,scopes,rate_limit_per_min:rate, owner_type:'admin'})})
        .then(r=>r.json()).then(d=>{
          const m = document.getElementById('create-result');
          m.style.display='block';
          if(d.success){
            m.style.color='#28a745';
            m.textContent='API Key erstellt. API_KEY und API_SECRET jetzt sicher kopieren!';
            try {
              const apiKey = d.key && d.key.api_key ? d.key.api_key : (d.api_key || '(unbekannt)');
              const apiSecret = d.key && d.key.secret_key ? d.key.secret_key : (d.api_secret || '(unbekannt)');
              alert('API_KEY: '+apiKey+'\nAPI_SECRET: '+apiSecret+'\nHinweis: Secret wird NICHT erneut angezeigt.');
            } catch(_) {}
            closeCreateKey();
            loadKeys();
          } else { m.style.color='#dc3545'; m.textContent=d.message||'Fehler'; }
        }).catch(e=>{
          const m = document.getElementById('create-result'); m.style.display='block'; m.textContent=e.message; 
        });
    }

    function openEditKey(idx){
      const k = keysCache[idx]; if(!k) return;
      document.getElementById('edit-key-id').value = k.id;
      document.getElementById('edit-key-name').value = k.name || '';
      document.getElementById('edit-key-rate').value = k.rate_limit_per_min || 60;
      document.getElementById('edit-key-active').checked = !!k.is_active;
      // Scopes füllen
      const selected = (()=>{ try{return JSON.parse(k.scopes||'[]');}catch(_){return [];} })();
      document.querySelectorAll('.scope-checkbox-edit').forEach(cb=>{ cb.checked = selected.includes(cb.value); });
      document.getElementById('edit-key-scopes-json').value = '';
      const m=document.getElementById('edit-key-modal'); m.classList.remove('hidden'); m.style.display='flex';
    }

    function closeEditKey(){ const m=document.getElementById('edit-key-modal'); m.classList.add('hidden'); m.style.display='none'; }

    function submitEditKey(){
      const id = parseInt(document.getElementById('edit-key-id').value,10);
      const name = document.getElementById('edit-key-name').value.trim();
      const rate = parseInt(document.getElementById('edit-key-rate').value||'60',10);
      const isActive = document.getElementById('edit-key-active').checked ? 1 : 0;
      let scopes = [];
      const jsonTxt = (document.getElementById('edit-key-scopes-json')?.value||'').trim();
      if(jsonTxt){ try{ scopes = JSON.parse(jsonTxt);}catch(e){ const m=document.getElementById('edit-result'); m.style.display='block'; m.style.color='#dc3545'; m.textContent='Ungültiges Scopes JSON'; return; } }
      else { scopes = Array.from(document.querySelectorAll('.scope-checkbox-edit:checked')).map(x=>x.value); }
      const body = { id, name, scopes, is_active: isActive, rate_limit_per_min: rate };
      fetch('api/api_keys.php',{ method:'PUT', headers:{'Content-Type':'application/json'}, body: JSON.stringify(body) })
        .then(r=>r.json()).then(d=>{
          const m=document.getElementById('edit-result'); m.style.display='block';
          if(d.success){ m.style.color='#28a745'; m.textContent='Gespeichert'; closeEditKey(); loadKeys(); }
          else { m.style.color='#dc3545'; m.textContent=d.message||'Fehler'; }
        }).catch(e=>{ const m=document.getElementById('edit-result'); m.style.display='block'; m.style.color='#dc3545'; m.textContent=e.message; });
    }

    function openDeactivateKey(id){ document.getElementById('deactivate-key-id').value = id; const m=document.getElementById('deactivate-key-modal'); m.classList.remove('hidden'); m.style.display='flex'; document.getElementById('deactivate-result').style.display='none'; }
    function closeDeactivateKey(){ const m=document.getElementById('deactivate-key-modal'); m.classList.add('hidden'); m.style.display='none'; }
    function confirmDeactivateKey(){
      const id = parseInt(document.getElementById('deactivate-key-id').value,10);
      fetch('api/api_keys.php', { method:'DELETE', headers:{'Content-Type':'application/json'}, body: JSON.stringify({ id }) })
        .then(r=>r.json()).then(d=>{
          const m=document.getElementById('deactivate-result'); m.style.display='block';
          if(d.success){ m.style.color='#28a745'; m.textContent='Key deaktiviert'; closeDeactivateKey(); loadKeys(); }
          else { m.style.color='#dc3545'; m.textContent=d.message||'Fehler'; }
        }).catch(e=>{ const m=document.getElementById('deactivate-result'); m.style.display='block'; m.style.color='#dc3545'; m.textContent=e.message; });
    }

    // updateKey entfernt – ersetzt durch Edit-Modal

    function loadUsage(){
      fetch('api/api_usage.php').then(r=>r.json()).then(d=>{
        if(!d.success){ renderEmptyStats(); return; }
        renderUsageStats(d.summary||{}, d.top_endpoints||[], d.logs||[]);
      }).catch(e=>{ console.error('Usage load failed:',e); renderEmptyStats(); });
    }

    function renderEmptyStats(){
      document.getElementById('usage-recent').innerHTML = '<div style="text-align:center;padding:2rem;color:#999;"><i class="fas fa-chart-line" style="font-size:3rem;opacity:0.5;display:block;margin-bottom:1rem;"></i>Noch keine Anfragen in den letzten 24h</div>';
      document.getElementById('usage-stats').innerHTML = '<div style="text-align:center;padding:2rem;color:#999;">Keine Daten</div>';
    }

    function renderUsageStats(summary, topEndpoints, recentLogs){
      // Summary Cards
      const total = summary.total_requests||0;
      const success = summary.success_requests||0;
      const client4xx = summary.client_errors||0;
      const server5xx = summary.server_errors||0;
      const totalBytes = (summary.total_bytes_in||0) + (summary.total_bytes_out||0);
      
      document.getElementById('usage-recent').innerHTML = `
        <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:1rem;">
          <div style="background:#28a745;color:white;padding:1.5rem;border-radius:12px;text-align:center;">
            <i class="fas fa-check-circle" style="font-size:2rem;display:block;margin-bottom:0.5rem;"></i>
            <strong style="font-size:1.5rem;display:block;">${success}</strong>
            <small>Erfolgreich</small>
          </div>
          <div style="background:#ffc107;color:#333;padding:1.5rem;border-radius:12px;text-align:center;">
            <i class="fas fa-exclamation-triangle" style="font-size:2rem;display:block;margin-bottom:0.5rem;"></i>
            <strong style="font-size:1.5rem;display:block;">${client4xx}</strong>
            <small>Client Fehler</small>
          </div>
          <div style="background:#dc3545;color:white;padding:1.5rem;border-radius:12px;text-align:center;">
            <i class="fas fa-times-circle" style="font-size:2rem;display:block;margin-bottom:0.5rem;"></i>
            <strong style="font-size:1.5rem;display:block;">${server5xx}</strong>
            <small>Server Fehler</small>
          </div>
          <div style="background:#2196f3;color:white;padding:1.5rem;border-radius:12px;text-align:center;">
            <i class="fas fa-database" style="font-size:2rem;display:block;margin-bottom:0.5rem;"></i>
            <strong style="font-size:1.5rem;display:block;">${formatBytes(totalBytes)}</strong>
            <small>Datenvolumen</small>
          </div>
        </div>
        ${topEndpoints.length>0 ? `<div style="margin-top:1.5rem;"><h4 style="margin-bottom:1rem;color:#333;">Top Endpoints</h4><div style="background:#f8f9fa;border-radius:8px;padding:1rem;overflow-x:auto;"><table style="width:100%;border-collapse:collapse;">${topEndpoints.map((ep,idx)=>{const pct = total>0 ? ((ep.count||0)/total*100).toFixed(1) : 0; const errs = ep.errors||0; return `<tr style="border-bottom:1px solid #dee2e6;"><td style="padding:0.75rem;">${idx+1}.</td><td style="padding:0.75rem;font-family:monospace;">${ep.endpoint||'-'}</td><td style="padding:0.75rem;text-align:right;"><strong>${ep.count||0}</strong> <small style="color:#999;">(${pct}%)</small></td><td style="padding:0.75rem;text-align:right;"><span style="background:${errs>0?'#ffc107':'#28a745'};color:${errs>0?'#333':'white'};padding:0.25rem 0.5rem;border-radius:4px;font-size:0.85rem;">${errs} Errors</span></td></tr>`;}).join('')}</table></div></div>` : ''}
        ${recentLogs.length>0 ? `<div style="margin-top:1.5rem;"><h4 style="margin-bottom:1rem;color:#333;">Letzte Anfragen</h4><div style="background:#f8f9fa;border-radius:8px;padding:1rem;max-height:300px;overflow-y:auto;"><table style="width:100%;border-collapse:collapse;font-size:0.9rem;">${recentLogs.slice(0,10).map(log=>{const statusColor = log.status_code>=200&&log.status_code<300?'#28a745':log.status_code>=400&&log.status_code<500?'#ffc107':'#dc3545'; return `<tr style="border-bottom:1px solid #dee2e6;"><td style="padding:0.5rem;color:#666;">${new Date(log.request_ts).toLocaleString()}</td><td style="padding:0.5rem;font-family:monospace;font-size:0.85rem;">${log.endpoint}</td><td style="padding:0.5rem;text-align:center;"><span style="background:${statusColor};color:white;padding:0.25rem 0.5rem;border-radius:4px;">${log.status_code}</span></td><td style="padding:0.5rem;text-align:right;font-family:monospace;">${log.ip||'-'}</td></tr>`;}).join('')}</table></div></div>` : ''}
      `;
      
      document.getElementById('usage-stats').innerHTML = `
        <div style="margin-top:1rem;">
          <div style="text-align:center;padding:2rem;background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);color:white;border-radius:12px;">
            <i class="fas fa-chart-bar" style="font-size:3rem;display:block;margin-bottom:1rem;"></i>
            <strong style="font-size:2.5rem;display:block;">${total}</strong>
            <small>Total Requests (24h)</small>
          </div>
        </div>
      `;
    }

    function formatBytes(bytes){
      if(bytes===0) return '0 B';
      const k=1024, sizes=['B','KB','MB','GB'], i=Math.floor(Math.log(bytes)/Math.log(k));
      return (bytes/Math.pow(k,i)).toFixed(2) + ' ' + sizes[i];
    }

    document.addEventListener('DOMContentLoaded', function(){ loadKeys(); loadUsage(); });
  </script>
</body>
</html>
