<?php
/**
 * WhatsApp Integration API
 * Verbindet appointments.php, storage.php und admin_dashboard.php mit hellomateo.php
 */

session_start();
require_once '../../config/database.php';
require_once '../includes/helpers.php';
require_once '../includes/hellomateo_api.php';

// Check if user is logged in
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'error' => 'Nicht angemeldet']);
    exit;
}

$db = new Database();
$conn = $db->getConnection();

$action = $_GET['action'] ?? $_POST['action'] ?? '';
$response = ['success' => false, 'error' => 'Unbekannte Aktion'];

// Get current user autohaus
$current_user_id = $_SESSION['admin_user_id'] ?? null;
$current_user_autohaus_id = null;

if ($current_user_id) {
    $stmt = $conn->prepare("SELECT autohaus_id FROM admin_users WHERE id = ?");
    $stmt->execute([$current_user_id]);
    $user_data = $stmt->fetch(PDO::FETCH_ASSOC);
    $current_user_autohaus_id = $user_data['autohaus_id'] ?? null;
}

// Get selected autohaus from session (for admins)
$selected_autohaus_id = $_SESSION['selected_autohaus_id'] ?? null;
$active_autohaus_id = $selected_autohaus_id ?? $current_user_autohaus_id;

$hellomateo = new HelloMateoAPI(null, $active_autohaus_id);

switch ($action) {
    case 'get_appointments_by_phone':
        $phone = $_GET['phone'] ?? $_POST['phone'] ?? '';
        if (empty($phone)) {
            $response = ['success' => false, 'error' => 'Telefonnummer fehlt'];
        } else {
            $phone = preg_replace('/[^0-9+]/', '', $phone);
            $stmt = $conn->prepare("SELECT id, customer_name, license_plate, slot_date, slot_time, status, event_id, phone FROM appointments WHERE phone = ? OR phone LIKE ? ORDER BY slot_date DESC, slot_time DESC LIMIT 20");
            $stmt->execute([$phone, '%' . $phone . '%']);
            $appointments = $stmt->fetchAll(PDO::FETCH_ASSOC);
            $response = ['success' => true, 'data' => $appointments];
        }
        break;
        
    case 'send_message_from_appointment':
        $appointmentId = $_POST['appointment_id'] ?? null;
        $message = $_POST['message'] ?? '';
        $templateId = $_POST['template_id'] ?? null;
        
        if (!$appointmentId) {
            $response = ['success' => false, 'error' => 'Appointment-ID fehlt'];
        } else {
            $stmt = $conn->prepare("SELECT phone, customer_name FROM appointments WHERE id = ?");
            $stmt->execute([$appointmentId]);
            $appointment = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if (!$appointment || empty($appointment['phone'])) {
                $response = ['success' => false, 'error' => 'Appointment nicht gefunden oder keine Telefonnummer'];
            } else {
                $result = $hellomateo->sendMessage($appointment['phone'], $message, $templateId);
                $response = $result;
            }
        }
        break;
        
    case 'get_whatsapp_stats':
        // Lade WhatsApp-Statistiken
        $messagesResult = $hellomateo->listMessages(1000, 0);
        $contactsResult = $hellomateo->listContacts(1000, 0);
        $templatesResult = $hellomateo->listTemplates(1000, 0);
        
        $stats = [
            'total_messages' => 0,
            'sent_messages' => 0,
            'delivered_messages' => 0,
            'read_messages' => 0,
            'failed_messages' => 0,
            'total_contacts' => 0,
            'total_templates' => 0,
            'messages_today' => 0,
            'messages_this_week' => 0,
            'messages_this_month' => 0
        ];
        
        if ($messagesResult['success'] && is_array($messagesResult['data'])) {
            $messages = $messagesResult['data'];
            $stats['total_messages'] = count($messages);
            
            $today = date('Y-m-d');
            $weekStart = date('Y-m-d', strtotime('-7 days'));
            $monthStart = date('Y-m-d', strtotime('-30 days'));
            
            foreach ($messages as $msg) {
                $status = strtolower($msg['status'] ?? '');
                if ($status === 'sent') $stats['sent_messages']++;
                if ($status === 'delivered') $stats['delivered_messages']++;
                if ($status === 'read') $stats['read_messages']++;
                if ($status === 'failed') $stats['failed_messages']++;
                
                $msgDate = $msg['created_at'] ?? '';
                if ($msgDate && strpos($msgDate, $today) === 0) $stats['messages_today']++;
                if ($msgDate && strpos($msgDate, $weekStart) >= 0) $stats['messages_this_week']++;
                if ($msgDate && strpos($msgDate, $monthStart) >= 0) $stats['messages_this_month']++;
            }
        }
        
        if ($contactsResult['success'] && is_array($contactsResult['data'])) {
            $stats['total_contacts'] = count($contactsResult['data']);
        }
        
        if ($templatesResult['success'] && is_array($templatesResult['data'])) {
            $stats['total_templates'] = count($templatesResult['data']);
        }
        
        $response = ['success' => true, 'data' => $stats];
        break;
        
    case 'get_recent_whatsapp_activity':
        $limit = intval($_GET['limit'] ?? 10);
        $messagesResult = $hellomateo->listMessages($limit, 0);
        
        $activities = [];
        if ($messagesResult['success'] && is_array($messagesResult['data'])) {
            foreach ($messagesResult['data'] as $msg) {
                $activities[] = [
                    'id' => $msg['id'] ?? $msg['message_id'] ?? '',
                    'type' => 'message',
                    'text' => substr($msg['text'] ?? $msg['blurb'] ?? '', 0, 100),
                    'status' => $msg['status'] ?? 'unknown',
                    'created_at' => $msg['created_at'] ?? '',
                    'recipient' => $msg['recipients'][0]['handle'] ?? $msg['to'] ?? ''
                ];
            }
        }
        
        $response = ['success' => true, 'data' => $activities];
        break;
        
    case 'check_whatsapp_status_for_appointment':
        $appointmentId = $_GET['appointment_id'] ?? $_POST['appointment_id'] ?? null;
        if (!$appointmentId) {
            $response = ['success' => false, 'error' => 'Appointment-ID fehlt'];
        } else {
            $stmt = $conn->prepare("SELECT phone FROM appointments WHERE id = ?");
            $stmt->execute([$appointmentId]);
            $appointment = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if (!$appointment || empty($appointment['phone'])) {
                $response = ['success' => false, 'error' => 'Appointment nicht gefunden oder keine Telefonnummer'];
            } else {
                $phone = preg_replace('/[^0-9+]/', '', $appointment['phone']);
                $messagesResult = $hellomateo->listMessages(100, 0);
                
                $hasMessages = false;
                $lastMessage = null;
                
                if ($messagesResult['success'] && is_array($messagesResult['data'])) {
                    foreach ($messagesResult['data'] as $msg) {
                        $recipients = $msg['recipients'] ?? [];
                        foreach ($recipients as $r) {
                            if (($r['handle'] ?? '') === $phone) {
                                $hasMessages = true;
                                if (!$lastMessage || ($msg['created_at'] ?? '') > ($lastMessage['created_at'] ?? '')) {
                                    $lastMessage = $msg;
                                }
                            }
                        }
                    }
                }
                
                $response = [
                    'success' => true,
                    'has_messages' => $hasMessages,
                    'last_message' => $lastMessage
                ];
            }
        }
        break;
}

header('Content-Type: application/json');
echo json_encode($response);
exit;
?>






