<?php
/**
 * Sicherer Dokumenten-Viewer für Verifikationsdokumente
 * Prüft Admin-Authentifizierung vor dem Anzeigen von Dokumenten
 */

session_start();

// Check if user is logged in as admin
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    http_response_code(401);
    die('Nicht autorisiert');
}

$file_path = $_GET['file'] ?? null;

if (!$file_path) {
    http_response_code(400);
    die('Dateipfad erforderlich');
}

// URL-dekodiere den Pfad
$file_path = urldecode($file_path);

// Sicherheitsprüfung: Nur Dateien aus dem verification_documents Verzeichnis erlauben
$base_upload_dir = realpath(__DIR__ . '/../../uploads/verification_documents/');

// Konvertiere relativen Pfad zu absolutem Pfad falls nötig
if (substr($file_path, 0, 1) !== '/' && substr($file_path, 0, 2) !== 'C:') {
    // Relativer Pfad - füge Base-Directory hinzu
    // Entferne "uploads/verification_documents/" falls vorhanden
    $clean_path = str_replace('uploads/verification_documents/', '', $file_path);
    
    // Entferne "../" Pfade für Sicherheit
    $clean_path = str_replace('../', '', $clean_path);
    
    // Entferne führende "/" falls vorhanden
    $clean_path = ltrim($clean_path, '/');
    
    $full_path = $base_upload_dir . '/' . $clean_path;
    $requested_path = realpath($full_path);
    
    // Falls realpath fehlschlägt, verwende den konstruierten Pfad
    if (!$requested_path) {
        $requested_path = $full_path;
    }
} else {
    // Absoluter Pfad - prüfe ob er im erlaubten Verzeichnis liegt
    $requested_path = realpath($file_path);
    
    // Falls realpath fehlschlägt, verwende den ursprünglichen Pfad
    if (!$requested_path) {
        $requested_path = $file_path;
    }
}

if (!$requested_path || substr($requested_path, 0, strlen($base_upload_dir)) !== $base_upload_dir) {
    http_response_code(403);
    die('Zugriff verweigert: Ungültiger Dateipfad. Base: ' . $base_upload_dir . ', Requested: ' . $requested_path);
}

// Prüfe ob Datei existiert
if (!file_exists($requested_path)) {
    http_response_code(404);
    die('Datei nicht gefunden');
}

// Bestimme MIME-Type
$mime_type = mime_content_type($requested_path);
$allowed_types = ['image/jpeg', 'image/png', 'image/gif', 'application/pdf', 'text/plain'];

if (!in_array($mime_type, $allowed_types)) {
    http_response_code(403);
    die('Dateityp nicht erlaubt: ' . $mime_type);
}

// Setze entsprechende Header
header('Content-Type: ' . $mime_type);
header('Content-Length: ' . filesize($requested_path));
header('Cache-Control: private, max-age=3600'); // 1 Stunde Cache
header('Content-Disposition: inline; filename="' . basename($requested_path) . '"');

// Output der Datei
readfile($requested_path);
?>
