<?php
/**
 * API: Aktualisiere Template-Konfiguration
 */

require_once __DIR__ . '/../../config/database.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Nur POST erlaubt']);
    exit;
}

$db = new Database();
$conn = $db->getConnection();

$data = json_decode(file_get_contents('php://input'), true);

$configId = $data['config_id'] ?? null;
$field = $data['field'] ?? null;
$value = $data['value'] ?? null;

if (!$configId || !$field) {
    echo json_encode(['success' => false, 'error' => 'Config-ID und Feld sind erforderlich']);
    exit;
}

try {
    $allowedFields = ['template_id', 'send_timing', 'send_timing_hours', 'is_active', 'custom_fields_mapping'];
    if (!in_array($field, $allowedFields)) {
        echo json_encode(['success' => false, 'error' => 'Ungültiges Feld']);
        exit;
    }
    
    if ($field === 'custom_fields_mapping' && is_array($value)) {
        $value = json_encode($value);
    }
    
    $stmt = $conn->prepare("UPDATE whatsapp_template_configs SET {$field} = ?, updated_at = NOW() WHERE id = ?");
    $stmt->execute([$value, $configId]);
    
    echo json_encode(['success' => true, 'message' => 'Konfiguration aktualisiert']);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}





