<?php
session_start();
require_once '../../config/database.php';

header('Content-Type: application/json');

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

$current_user_id = $_SESSION['admin_user_id'] ?? null;
if (!$current_user_id) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Benutzer-ID nicht gefunden']);
    exit;
}

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['columns']) || !is_array($input['columns'])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Ungültige Daten']);
        exit;
    }
    
    $columns_json = json_encode($input['columns']);
    
    // Prüfe ob Einstellung bereits existiert
    $stmt = $conn->prepare("SELECT id FROM admin_settings WHERE user_id = ? AND setting_key = 'appointments_columns'");
    $stmt->execute([$current_user_id]);
    $existing = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($existing) {
        // Update vorhandene Einstellung
        $stmt = $conn->prepare("UPDATE admin_settings SET setting_value = ?, updated_at = NOW() WHERE user_id = ? AND setting_key = 'appointments_columns'");
        $stmt->execute([$columns_json, $current_user_id]);
    } else {
        // Erstelle neue Einstellung
        $stmt = $conn->prepare("INSERT INTO admin_settings (user_id, setting_key, setting_value) VALUES (?, 'appointments_columns', ?)");
        $stmt->execute([$current_user_id, $columns_json]);
    }
    
    echo json_encode(['success' => true, 'message' => 'Spalten-Einstellungen gespeichert']);
    
} catch (Exception $e) {
    error_log("Error saving column preferences: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Fehler beim Speichern: ' . $e->getMessage()]);
}
?>

