<?php
/**
 * Retry WhatsApp Message API
 * Erlaubt das erneute Versenden einer fehlgeschlagenen WhatsApp-Nachricht
 */

session_start();
require_once '../../config/database.php';
require_once '../includes/helpers.php';
require_once '../includes/hellomateo_api.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    echo json_encode(['success' => false, 'error' => 'Nicht angemeldet']);
    exit;
}

$db = new Database();
$conn = $db->getConnection();

// Get current user autohaus
$current_user_id = $_SESSION['admin_user_id'] ?? null;
$current_user_autohaus_id = null;

if ($current_user_id) {
    $stmt = $conn->prepare("SELECT autohaus_id FROM admin_users WHERE id = ?");
    $stmt->execute([$current_user_id]);
    $user_data = $stmt->fetch(PDO::FETCH_ASSOC);
    $current_user_autohaus_id = $user_data['autohaus_id'] ?? null;
}

// Get selected autohaus from session (for admins)
$selected_autohaus_id = $_SESSION['selected_autohaus_id'] ?? null;
$active_autohaus_id = $selected_autohaus_id ?? $current_user_autohaus_id;

$input = json_decode(file_get_contents('php://input'), true);
$logId = $input['log_id'] ?? null;

if (!$logId) {
    echo json_encode(['success' => false, 'error' => 'Log-ID fehlt']);
    exit;
}

// Lade Log-Eintrag
$stmt = $conn->prepare("
    SELECT wl.*, a.name as autohaus_name
    FROM whatsapp_logs wl
    LEFT JOIN autohaus a ON wl.autohaus_id = a.id
    WHERE wl.id = ?
");
$stmt->execute([$logId]);
$log = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$log) {
    echo json_encode(['success' => false, 'error' => 'Log-Eintrag nicht gefunden']);
    exit;
}

// Prüfe ob Autohaus-Berechtigung vorhanden
if ($current_user_autohaus_id && $log['autohaus_id'] != $current_user_autohaus_id) {
    echo json_encode(['success' => false, 'error' => 'Keine Berechtigung für dieses Autohaus']);
    exit;
}

// Verwende das Autohaus aus dem Log, falls vorhanden
$logAutohausId = $log['autohaus_id'] ?? $active_autohaus_id;
$hellomateo = new HelloMateoAPI(null, $logAutohausId);

// Versuche Nachricht erneut zu senden
$phone = $log['phone_number'];
$message = $log['message'];
$templateId = $log['template_id'] ?? null;
$actionType = $log['action_type'];

try {
    $result = $hellomateo->sendMessage($phone, $message, $templateId);
    
    // Erstelle neuen Log-Eintrag
    $stmt = $conn->prepare("
        INSERT INTO whatsapp_logs (
            autohaus_id, appointment_id, customer_name, phone_number,
            action_type, message, template_id, status, error_message,
            response_data, created_at
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())
    ");
    
    $newStatus = $result['success'] ? 'success' : 'error';
    $errorMessage = $result['success'] ? null : ($result['error'] ?? $result['message'] ?? 'Unbekannter Fehler');
    $responseData = json_encode($result);
    
    $stmt->execute([
        $log['autohaus_id'],
        $log['appointment_id'],
        $log['customer_name'],
        $phone,
        $actionType . '_retry',
        $message,
        $templateId,
        $newStatus,
        $errorMessage,
        $responseData
    ]);
    
    echo json_encode([
        'success' => $result['success'],
        'message' => $result['success'] ? 'Nachricht erfolgreich erneut versendet' : ($result['error'] ?? 'Fehler beim erneuten Versenden'),
        'log_id' => $conn->lastInsertId()
    ]);
    
} catch (Exception $e) {
    // Erstelle Log-Eintrag für Fehler
    $stmt = $conn->prepare("
        INSERT INTO whatsapp_logs (
            autohaus_id, appointment_id, customer_name, phone_number,
            action_type, message, template_id, status, error_message,
            response_data, created_at
        ) VALUES (?, ?, ?, ?, ?, ?, ?, 'error', ?, ?, NOW())
    ");
    
    $errorMessage = $e->getMessage();
    $stmt->execute([
        $log['autohaus_id'],
        $log['appointment_id'],
        $log['customer_name'],
        $phone,
        $actionType . '_retry',
        $message,
        $templateId,
        $errorMessage,
        json_encode(['exception' => $errorMessage])
    ]);
    
    echo json_encode([
        'success' => false,
        'error' => 'Fehler beim erneuten Versenden: ' . $errorMessage
    ]);
}
?>




