<?php
/**
 * API: Lade vollständige Template-Details (lazy loading)
 * Wird nur aufgerufen, wenn Details benötigt werden (z.B. für Vorschau)
 */

// Session sicher starten (nur wenn noch nicht gestartet)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Output-Buffering aktivieren
ob_start();

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../includes/hellomateo_api.php';

// Setze Header nach require_once
header('Content-Type: application/json');

// Prüfe Authentifizierung
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    ob_clean();
    echo json_encode(['success' => false, 'error' => 'Nicht authentifiziert']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    ob_clean();
    echo json_encode(['success' => false, 'error' => 'Nur GET erlaubt']);
    exit;
}

$templateId = $_GET['template_id'] ?? null;
$autohausId = $_GET['autohaus_id'] ?? null;

if (!$templateId) {
    ob_clean();
    echo json_encode(['success' => false, 'error' => 'Template-ID erforderlich']);
    exit;
}

if (!$autohausId) {
    ob_clean();
    echo json_encode(['success' => false, 'error' => 'Autohaus-ID erforderlich']);
    exit;
}

try {
    // Prüfe ob API-Key in Datenbank existiert
    $db = new Database();
    $conn = $db->getConnection();
    $stmt = $conn->prepare("SELECT id, name, whatsapp_api_key FROM autohaus WHERE id = ?");
    $stmt->execute([$autohausId]);
    $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$autohaus || empty($autohaus['whatsapp_api_key'])) {
        ob_clean();
        echo json_encode(['success' => false, 'error' => 'WhatsApp API-Key nicht konfiguriert']);
        exit;
    }
    
    // Erstelle HelloMateo API Instanz
    $autohausIdInt = intval($autohausId);
    $hellomateo = new HelloMateoAPI(null, $autohausIdInt);
    
    // Lade vollständige Template-Details
    $templateDetails = $hellomateo->getTemplateById($templateId);
    
    if ($templateDetails['success'] && !empty($templateDetails['data'])) {
        $detailData = is_array($templateDetails['data']) && isset($templateDetails['data'][0]) 
            ? $templateDetails['data'][0] 
            : $templateDetails['data'];
        
        // Extrahiere Components
        $components = $detailData['components'] ?? [];
        
        // Baue Components aus separaten Feldern, falls nötig
        if (empty($components) && (isset($detailData['body']) || isset($detailData['header']) || isset($detailData['footer']))) {
            $components = [];
            if (isset($detailData['header'])) {
                $headerText = is_array($detailData['header']) ? ($detailData['header']['text'] ?? $detailData['header']['content'] ?? '') : $detailData['header'];
                $components[] = [
                    'type' => 'HEADER',
                    'text' => $headerText,
                    'format' => is_array($detailData['header']) ? ($detailData['header']['format'] ?? null) : null
                ];
            }
            if (isset($detailData['body'])) {
                $bodyText = is_array($detailData['body']) ? ($detailData['body']['text'] ?? $detailData['body']['content'] ?? '') : $detailData['body'];
                $components[] = [
                    'type' => 'BODY',
                    'text' => $bodyText,
                    'content' => is_array($detailData['body']) ? ($detailData['body']['content'] ?? null) : null
                ];
            }
            if (isset($detailData['footer'])) {
                $footerText = is_array($detailData['footer']) ? ($detailData['footer']['text'] ?? $detailData['footer']['content'] ?? '') : $detailData['footer'];
                $components[] = [
                    'type' => 'FOOTER',
                    'text' => $footerText
                ];
            }
        }
        
        ob_clean();
        echo json_encode([
            'success' => true,
            'data' => [
                'id' => $detailData['id'] ?? $templateId,
                'name' => $detailData['name'] ?? '',
                'components' => $components,
                'body' => $detailData['body'] ?? null,
                'header' => $detailData['header'] ?? null,
                'footer' => $detailData['footer'] ?? null,
            ]
        ]);
    } else {
        ob_clean();
        echo json_encode([
            'success' => false,
            'error' => $templateDetails['error'] ?? 'Template-Details konnten nicht geladen werden'
        ]);
    }
} catch (Exception $e) {
    error_log("get_template_details.php: Exception - " . $e->getMessage());
    ob_clean();
    echo json_encode([
        'success' => false,
        'error' => 'Fehler: ' . $e->getMessage()
    ]);
}

ob_end_flush();




