<?php
session_start();
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

require_once __DIR__ . '/../../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    $method = $_SERVER['REQUEST_METHOD'];

    if ($method === 'GET') {
        // Liste aller Keys (ohne Klartext-Secret/Key)
        $stmt = $conn->query("SELECT id, name, scopes, is_active, rate_limit_per_min, owner_type, owner_id, created_at, last_used_at FROM api_keys ORDER BY created_at DESC");
        $keys = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode(['success' => true, 'keys' => $keys]);
        exit;
    }

    $input = json_decode(file_get_contents('php://input'), true) ?? [];

    if ($method === 'POST') {
        // Create: generiert API_KEY/API_SECRET einmalig, speichert nur Hashes
        $name = trim($input['name'] ?? '');
        $scopes = $input['scopes'] ?? [];
        $rate = (int)($input['rate_limit_per_min'] ?? 60);
        if ($name === '' || !is_array($scopes)) {
            throw new Exception('Name und Scopes sind erforderlich');
        }
        $apiKey = bin2hex(random_bytes(16));
        $apiSecret = bin2hex(random_bytes(32));
        $keyHash = hash('sha256', $apiKey);
        $secretHash = hash('sha256', $apiSecret);
        $stmt = $conn->prepare("INSERT INTO api_keys (name, key_hash, secret_hash, scopes, is_active, rate_limit_per_min) VALUES (?, ?, ?, ?, 1, ?)");
        $stmt->execute([$name, $keyHash, $secretHash, json_encode($scopes, JSON_UNESCAPED_UNICODE), $rate]);
        echo json_encode(['success' => true, 'api_key' => $apiKey, 'api_secret' => $apiSecret]);
        exit;
    }

    if ($method === 'PUT') {
        // Update: Scopes/Status/Rate
        $id = (int)($input['id'] ?? 0);
        if ($id <= 0) throw new Exception('ID erforderlich');
        $fields = [];
        $params = [];
        if (isset($input['name'])) { $fields[] = 'name = ?'; $params[] = trim($input['name']); }
        if (isset($input['scopes'])) { $fields[] = 'scopes = ?'; $params[] = json_encode($input['scopes'], JSON_UNESCAPED_UNICODE); }
        if (isset($input['is_active'])) { $fields[] = 'is_active = ?'; $params[] = (int)$input['is_active']; }
        if (isset($input['rate_limit_per_min'])) { $fields[] = 'rate_limit_per_min = ?'; $params[] = (int)$input['rate_limit_per_min']; }
        if (empty($fields)) throw new Exception('Keine Felder zum Aktualisieren');
        $params[] = $id;
        $sql = 'UPDATE api_keys SET ' . implode(', ', $fields) . ' WHERE id = ?';
        $stmt = $conn->prepare($sql);
        $stmt->execute($params);
        echo json_encode(['success' => true, 'message' => 'Aktualisiert']);
        exit;
    }

    if ($method === 'DELETE') {
        // Löschen/Deaktivieren
        $id = (int)($_GET['id'] ?? 0);
        if ($id <= 0) { $id = (int)($input['id'] ?? 0); }
        if ($id <= 0) throw new Exception('ID erforderlich');
        $stmt = $conn->prepare("UPDATE api_keys SET is_active = 0 WHERE id = ?");
        $stmt->execute([$id]);
        echo json_encode(['success' => true, 'message' => 'Deaktiviert']);
        exit;
    }

    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Methode nicht unterstützt']);
} catch (Throwable $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
