# 📋 Anleitung: Drucker-Freigabe und -Erkennung

## 🎯 Übersicht

Diese Anleitung erklärt, wie Sie einen Netzwerkdrucker richtig freigeben und konfigurieren, damit er von der Boxenstop-Anwendung zuverlässig erkannt und verwendet werden kann.

---

## 📌 Schritt 1: Drucker auf dem Server freigeben

### 1.1 Drucker auf dem Server installieren

1. **Öffnen Sie die Druckerverwaltung auf dem Server:**
   - Windows-Taste + R
   - Geben Sie `control printers` ein
   - Oder: Einstellungen → Geräte → Drucker & Scanner

2. **Drucker hinzufügen (falls noch nicht installiert):**
   - Klicken Sie auf "Drucker oder Scanner hinzufügen"
   - Wählen Sie den Drucker aus oder fügen Sie ihn über IP-Adresse hinzu

3. **Drucker-Eigenschaften öffnen:**
   - Rechtsklick auf den Drucker → "Druckereigenschaften"

### 1.2 Drucker freigeben

1. **Wechseln Sie zum Tab "Freigabe":**
   - Aktivieren Sie "Drucker freigeben"
   - **WICHTIG:** Geben Sie dem Drucker einen **eindeutigen, einfachen Namen**:
     - ✅ **Gut:** `BUEK-PRT17`, `PRT17`, `LABELPRINTER`
     - ❌ **Schlecht:** `BUEK-PRT17 (TSC TTP-244CE)`, `Drucker 1`, `Etikettendrucker`

2. **Freigabename festlegen:**
   - Der Freigabename sollte **ohne Sonderzeichen** sein
   - **Maximal 31 Zeichen** (Windows-Limit)
   - **Keine Leerzeichen am Anfang oder Ende**

3. **Berechtigungen prüfen:**
   - Tab "Sicherheit"
   - Stellen Sie sicher, dass die Benutzergruppe "Jeder" oder die entsprechende Gruppe "Drucken" erlaubt ist

### 1.3 Drucker-Treiber prüfen

1. **Tab "Erweitert":**
   - Stellen Sie sicher, dass der richtige Treiber installiert ist
   - **WICHTIG:** Verwenden Sie einen **generischen Treiber**, falls möglich:
     - "Bar Code Printer TTP068-50" (für TSC-Drucker)
     - "Generic / Text Only" (als Fallback)

---

## 📌 Schritt 2: Netzwerk-Freigabe konfigurieren

### 2.1 Windows-Freigabe aktivieren

1. **Netzwerk- und Freigabecenter öffnen:**
   - Windows-Taste + R → `control /name Microsoft.NetworkAndSharingCenter`

2. **Erweiterte Freigabeeinstellungen:**
   - Klicken Sie auf "Erweiterte Freigabeeinstellungen ändern"
   - Aktivieren Sie:
     - ✅ "Netzwerkerkennung aktivieren"
     - ✅ "Datei- und Druckerfreigabe aktivieren"
     - ✅ "Automatische Einrichtung von Netzwerkgeräten aktivieren"

### 2.2 Firewall konfigurieren

1. **Windows-Firewall öffnen:**
   - Windows-Taste + R → `wf.msc`

2. **Regel für Druckerfreigabe erstellen:**
   - Klicken Sie auf "Eingehende Regeln" → "Neue Regel"
   - Regeltyp: "Port"
   - Protokoll: TCP
   - Ports: 139, 445, 515
   - Aktion: "Verbindung zulassen"
   - Profil: Alle aktivieren
   - Name: "Druckerfreigabe"

---

## 📌 Schritt 3: Drucker auf Client installieren

### 3.1 Manuelle Installation (Empfohlen)

**Methode 1: Windows Explorer (Einfachste Methode)**

1. **Öffnen Sie Windows Explorer:**
   - Windows-Taste + E

2. **Navigieren Sie zum Server:**
   - In der Adresszeile eingeben: `\\100.82.207.72` (oder `\\buek-s01`)
   - Drücken Sie Enter

3. **Anmeldedaten eingeben:**
   - Benutzername: `VOLVOKIE\Projekt` (oder entsprechend)
   - Passwort: `start#2025` (oder entsprechend)
   - **WICHTIG:** ✅ Aktivieren Sie "Anmeldedaten speichern"

4. **Drucker verbinden:**
   - Rechtsklick auf den Drucker → "Drucker verbinden"
   - Warten Sie, bis die Installation abgeschlossen ist

5. **Drucker-Name prüfen:**
   - Öffnen Sie "Drucker & Scanner" in Windows
   - Der Drucker sollte jetzt sichtbar sein
   - **Notieren Sie sich den exakten Namen** (z.B. `PRT17_BUEK-Server`)

**Methode 2: PowerShell (Für Administratoren)**

```powershell
# Verbinde mit Server
net use \\100.82.207.72 "start#2025" /user:"VOLVOKIE\Projekt"

# Installiere Drucker
Add-Printer -ConnectionName "\\100.82.207.72\BUEK-PRT17"
```

**Methode 3: Kommandozeile**

```cmd
rundll32 printui.dll,PrintUIEntry /in /n "\\100.82.207.72\BUEK-PRT17"
```

### 3.2 Drucker-Name nach Installation prüfen

1. **PowerShell öffnen (als Administrator):**
   ```powershell
   Get-Printer | Select-Object Name, PortName, PrinterStatus
   ```

2. **Suchen Sie nach Ihrem Drucker:**
   - Der Name kann sich von der Freigabe unterscheiden
   - Beispiel: Freigabe = `BUEK-PRT17`, Lokaler Name = `PRT17_BUEK-Server`

3. **Port prüfen:**
   - Der Port sollte ein **Netzwerkport** sein (z.B. `\\100.82.207.72\BUEK-PRT17`)
   - **NICHT** `LPT1`, `COM1`, etc.

---

## 📌 Schritt 4: In Boxenstop konfigurieren

### 4.1 Autohaus-Einstellungen öffnen

1. **Loggen Sie sich als Admin ein**
2. **Gehen Sie zu:** Einstellungen → Autohaus-Verwaltung
3. **Klicken Sie auf "Bearbeiten"** bei dem gewünschten Autohaus

### 4.2 Drucker-Einstellungen eingeben

1. **Drucker aktiviert:** ✅ Aktivieren
2. **Lokaler Druckername:** Der Name, wie er in Windows angezeigt wird
   - Beispiel: `PRT17_BUEK-Server`
3. **Druckername auf Server:** Der Freigabename auf dem Server
   - Beispiel: `BUEK-PRT17`
4. **Drucker-Server IP:** Die IP-Adresse des Servers
   - Beispiel: `100.82.207.72`
5. **Drucker-Server Hostname:** Der Hostname des Servers
   - Beispiel: `buek-s01`
6. **Drucker-Server Benutzername:** Der Benutzername für die Verbindung
   - Beispiel: `VOLVOKIE\Projekt`
7. **Drucker-Server Passwort:** Das Passwort für die Verbindung
   - Beispiel: `start#2025`

### 4.3 Speichern und testen

1. **Klicken Sie auf "Speichern"**
2. **Testen Sie den Druck:**
   - Gehen Sie zu Termine → Wählen Sie einen Termin → "Etikett drucken"
   - Der Drucker sollte automatisch erkannt werden

---

## 🔍 Fehlerbehebung

### Problem: Drucker wird nicht erkannt

**Lösung 1: Drucker-Name prüfen**
```powershell
# Alle installierten Drucker anzeigen
Get-Printer | Select-Object Name, PortName
```

**Lösung 2: Port prüfen**
```powershell
# Port-Informationen anzeigen
Get-Printer -Name "PRT17_BUEK-Server" | Select-Object PortName
```

**Lösung 3: Netzwerkverbindung prüfen**
```cmd
# Server erreichbar?
ping 100.82.207.72

# Freigaben anzeigen
net view \\100.82.207.72
```

### Problem: "Gerät konnte nicht initialisiert werden"

**Ursache:** Anmeldedaten nicht gespeichert

**Lösung:**
1. Öffnen Sie Windows Explorer
2. Navigieren Sie zu `\\100.82.207.72`
3. Geben Sie die Anmeldedaten ein
4. **WICHTIG:** ✅ Aktivieren Sie "Anmeldedaten speichern"
5. Versuchen Sie erneut zu drucken

### Problem: Drucker hat falschen Port (LPT1)

**Lösung:**
1. Drucker löschen
2. Neu installieren über Windows Explorer (siehe Schritt 3.1)
3. Oder Port manuell ändern:
   ```powershell
   # Port hinzufügen
   Add-PrinterPort -Name "\\100.82.207.72\BUEK-PRT17"
   
   # Drucker auf Port setzen
   Set-Printer -Name "PRT17_BUEK-Server" -PortName "\\100.82.207.72\BUEK-PRT17"
   ```

### Problem: Drucker ist offline

**Lösung:**
```powershell
# Drucker online setzen
Set-Printer -Name "PRT17_BUEK-Server" -PrinterStatus "Normal"
```

---

## ✅ Checkliste

- [ ] Drucker auf Server installiert
- [ ] Drucker freigegeben mit eindeutigem Namen
- [ ] Netzwerkfreigabe aktiviert
- [ ] Firewall-Regeln konfiguriert
- [ ] Drucker auf Client installiert (über Windows Explorer)
- [ ] Anmeldedaten gespeichert
- [ ] Drucker-Name notiert (lokal und Server)
- [ ] Port ist Netzwerkport (nicht LPT/COM)
- [ ] In Boxenstop konfiguriert
- [ ] Testdruck erfolgreich

---

## 📞 Support

Bei Problemen:
1. Prüfen Sie die Windows-Ereignisanzeige (Event Viewer)
2. Prüfen Sie die Drucker-Warteschlange
3. Kontaktieren Sie den Systemadministrator

---

**Letzte Aktualisierung:** 2025-01-XX







