<?php
echo "<h1>Einfacher HTML-Test</h1>";

// Direkte URL testen
$url = "https://resy.dtm-reifen.de/index.php?m=wheelset&a=edit&LGS_ID=9718476&FN=WheelsetResult";

echo "<h2>URL:</h2>";
echo "<p>$url</p>";

echo "<h2>HTTP-Request:</h2>";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "<p style='color: red;'>cURL Error: $error</p>";
} else {
    echo "<p>HTTP Code: $httpCode</p>";
    echo "<p>Response Length: " . strlen($response) . " bytes</p>";
    
    if ($httpCode === 200) {
        echo "<h3>HTML-Preview (erste 2000 Zeichen):</h3>";
        echo "<pre style='background: #f0f0f0; padding: 10px; border: 1px solid #ccc; max-height: 400px; overflow-y: auto;'>";
        echo htmlspecialchars(substr($response, 0, 2000));
        echo "</pre>";
        
        // Prüfe ob es eine Login-Seite ist
        if (strpos($response, 'Anmeldename') !== false) {
            echo "<p style='color: red;'><strong>WARNUNG: Das ist eine Login-Seite!</strong></p>";
        }
        
        if (strpos($response, 'WheelHALTERNAME') !== false) {
            echo "<p style='color: green;'><strong>SUCCESS: WheelHALTERNAME gefunden!</strong></p>";
        } else {
            echo "<p style='color: red;'><strong>PROBLEM: WheelHALTERNAME nicht gefunden!</strong></p>";
        }
        
        // Suche nach allen IDs
        preg_match_all('/id="([^"]+)"/', $response, $matches);
        $ids = $matches[1];
        
        echo "<h3>Alle gefundenen IDs:</h3>";
        echo "<ul>";
        foreach ($ids as $id) {
            echo "<li>$id</li>";
        }
        echo "</ul>";
        
    } else {
        echo "<p style='color: red;'>HTTP Error: $httpCode</p>";
    }
}
?>
