<?php
echo "=== TESTING RESY API WITH DEBUG LOGS ===\n\n";

$url = 'http://172.24.10.114:8080/api/check_tire_status_real_resy.php';

$testCases = [
    '9.718.498' => 'Test Einlagerungsnummer 9.718.498'
];

foreach ($testCases as $storageNumber => $description) {
    echo "--- Testing: {$description} ---\n";
    echo "Storage Number: {$storageNumber}\n";
    
    $data = ['storage_number' => $storageNumber];
    
    $options = [
        'http' => [
            'header' => "Content-Type: application/json\r\n",
            'method' => 'POST',
            'content' => json_encode($data),
            'ignore_errors' => true,
            'timeout' => 60
        ]
    ];
    
    $context = stream_context_create($options);
    $result = file_get_contents($url, false, $context);
    
    if (strlen($result) > 0) {
        $parsed = json_decode($result, true);
        if (json_last_error() === JSON_ERROR_NONE) {
            echo "✅ JSON PARSING SUCCESS\n";
            echo "✅ Success: " . ($parsed['success'] ? 'true' : 'false') . "\n";
            
            if ($parsed['success'] && isset($parsed['data'])) {
                echo "✅ Einlagerungsnummer: " . $parsed['data']['einlagerungsnummer'] . "\n";
                echo "✅ Haltername: " . $parsed['data']['haltername'] . "\n";
                echo "✅ Kennzeichen: " . $parsed['data']['kennzeichen'] . "\n";
                echo "✅ Fahrzeugtyp: " . $parsed['data']['fahrzeugtyp'] . "\n";
                
                if (isset($parsed['data']['reifen_vl'])) {
                    echo "✅ Reifen VL: " . $parsed['data']['reifen_vl']['volltext'] . "\n";
                    echo "✅ Reifen VL Zustand: " . $parsed['data']['reifen_vl']['zustand'] . "\n";
                }
                
                echo "✅ Source: " . $parsed['metadata']['source'] . "\n";
                echo "✅ Processing Time: " . $parsed['metadata']['processing_time_ms'] . "ms\n";
            } else {
                echo "❌ API Error: " . ($parsed['error'] ?? 'Unknown error') . "\n";
                if (isset($parsed['metadata']['debug_info'])) {
                    echo "❌ Debug Info: " . json_encode($parsed['metadata']['debug_info']) . "\n";
                }
            }
        } else {
            echo "❌ JSON PARSING ERROR: " . json_last_error_msg() . "\n";
            echo "Raw response (first 500 chars): " . substr($result, 0, 500) . "...\n";
        }
    } else {
        echo "❌ No response\n";
    }
    
    echo "\n";
}

echo "=== CHECKING PHP ERROR LOGS ===\n";
$logFile = 'api/php_errors.log';
if (file_exists($logFile)) {
    $logs = file_get_contents($logFile);
    $lines = explode("\n", $logs);
    $recentLines = array_slice($lines, -50); // Letzte 50 Zeilen
    
    foreach ($recentLines as $line) {
        if (!empty(trim($line))) {
            echo $line . "\n";
        }
    }
} else {
    echo "❌ Log file not found: {$logFile}\n";
}
?>
