<?php
echo "=== TESTING REAL RESY INTEGRATION ===\n";

$url = 'http://172.24.10.114:8080/api/check_tire_status.php';
$data = [
    'storage_number' => '9.716.991',
    'appointment_date' => '',
    'event_name' => 'Test'
];

$options = [
    'http' => [
        'header' => "Content-Type: application/json\r\n",
        'method' => 'POST',
        'content' => json_encode($data),
        'ignore_errors' => true,
        'timeout' => 60
    ]
];

$context = stream_context_create($options);
$result = file_get_contents($url, false, $context);

echo "Response Length: " . strlen($result) . "\n";

if (strlen($result) > 0) {
    $parsed = json_decode($result, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        echo "✅ JSON PARSING SUCCESS\n";
        echo "✅ Success: " . ($parsed['success'] ? 'true' : 'false') . "\n";
        
        if ($parsed['success'] && isset($parsed['data'])) {
            echo "✅ Einlagerungsnummer: " . $parsed['data']['einlagerungsnummer'] . "\n";
            echo "✅ Kennzeichen: " . $parsed['data']['kennzeichen'] . "\n";
            echo "✅ Fahrzeug: " . $parsed['data']['fahrzeugtyp'] . "\n";
            
            if (isset($parsed['data']['reifen_vl'])) {
                echo "✅ Reifen VL: " . $parsed['data']['reifen_vl']['volltext'] . "\n";
                echo "✅ Reifen VL Zustand: " . $parsed['data']['reifen_vl']['zustand'] . "\n";
            }
            
            echo "\n=== METADATA ===\n";
            if (isset($parsed['metadata'])) {
                echo "Source: " . $parsed['metadata']['source'] . "\n";
                echo "Timestamp: " . $parsed['metadata']['timestamp'] . "\n";
            }
        } else {
            echo "❌ API Error: " . ($parsed['error'] ?? 'Unknown error') . "\n";
        }
    } else {
        echo "❌ JSON PARSING ERROR: " . json_last_error_msg() . "\n";
        echo "Raw response (first 500 chars): " . substr($result, 0, 500) . "...\n";
    }
} else {
    echo "❌ No response\n";
}
?>
