<?php
/**
 * Lokaler Test der RESY API
 */

echo "<h1>Lokaler RESY API Test</h1>";

// Simuliere POST-Request
$_SERVER['REQUEST_METHOD'] = 'POST';
$_SERVER['CONTENT_TYPE'] = 'application/json';

// Test 1: Grundfunktionstest
echo "<h2>Test 1: Grundfunktionstest</h2>";

// Simuliere Input
$testInput = json_encode(['action' => 'test']);
file_put_contents('php://temp', $testInput);

// Include der API
ob_start();
include 'api/resy_data_extraction_debug.php';
$output = ob_get_clean();

echo "<pre>";
echo "Input: " . $testInput . "\n\n";
echo "Output: " . $output . "\n\n";

$decoded = json_decode($output, true);
if ($decoded) {
    echo "Decoded JSON:\n";
    print_r($decoded);
} else {
    echo "JSON Decode Error: " . json_last_error_msg() . "\n";
}
echo "</pre>";

// Test 2: Login Test
echo "<h2>Test 2: Login Test</h2>";

$loginInput = json_encode(['action' => 'login', 'appointment_id' => 1]);

ob_start();
include 'api/resy_data_extraction_debug.php';
$output = ob_get_clean();

echo "<pre>";
echo "Input: " . $loginInput . "\n\n";
echo "Output: " . $output . "\n\n";

$decoded = json_decode($output, true);
if ($decoded) {
    echo "Decoded JSON:\n";
    print_r($decoded);
} else {
    echo "JSON Decode Error: " . json_last_error_msg() . "\n";
}
echo "</pre>";

echo "<h2>Log-Datei</h2>";
echo "<pre>";
if (file_exists('logs/resy_extraction.log')) {
    echo file_get_contents('logs/resy_extraction.log');
} else {
    echo "Log-Datei nicht gefunden.";
}
echo "</pre>";
?>
