<?php
// Teste das LGS_ID-basierte Parsing direkt
require_once 'api/get_stored_wheelsets.php';

// Lade die gespeicherte HTML-Antwort
$htmlFile = sys_get_temp_dir() . '/resy_wheelsets_response_1.html';

if (file_exists($htmlFile)) {
    $html = file_get_contents($htmlFile);
    echo "<h1>LGS_ID Parsing Test</h1>";
    echo "<p>HTML-Datei gefunden: " . strlen($html) . " bytes</p>";
    
    // Erstelle eine Instanz der Klasse
    $service = new ResyWheelsetService(1);
    
    // Verwende Reflection um die private Methode zu testen
    $reflection = new ReflectionClass($service);
    $method = $reflection->getMethod('parseLgsIdBasedWheelsets');
    $method->setAccessible(true);
    
    // Führe das Parsing aus
    $wheelsets = $method->invoke($service, $html);
    
    echo "<h2>Ergebnis:</h2>";
    echo "<p>Gefundene Reifensätze: " . count($wheelsets) . "</p>";
    
    if (!empty($wheelsets)) {
        echo "<h3>Erste 10 Reifensätze:</h3>";
        echo "<table border='1'>";
        echo "<tr><th>Satznummer</th><th>Kennzeichen</th><th>Fahrzeug</th><th>Halter</th><th>Eingangsdatum</th></tr>";
        
        foreach (array_slice($wheelsets, 0, 10) as $wheelset) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($wheelset['satznummer']) . "</td>";
            echo "<td>" . htmlspecialchars($wheelset['kennzeichen']) . "</td>";
            echo "<td>" . htmlspecialchars($wheelset['fahrzeug']) . "</td>";
            echo "<td>" . htmlspecialchars($wheelset['halter']) . "</td>";
            echo "<td>" . htmlspecialchars($wheelset['eingangsdatum']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p style='color: red;'>Keine Reifensätze gefunden!</p>";
    }
    
    // Teste auch die LGS_ID-Suche direkt
    echo "<h3>LGS_ID Suche Test:</h3>";
    if (preg_match_all('/LGS_ID[^>]*>([^<]+)</', $html, $lgsMatches)) {
        echo "<p>LGS_ID-Einträge gefunden: " . count($lgsMatches[1]) . "</p>";
        echo "<p>Erste 10 LGS_ID-Werte:</p>";
        echo "<ul>";
        foreach (array_slice($lgsMatches[1], 0, 10) as $index => $value) {
            echo "<li>" . htmlspecialchars(trim($value)) . "</li>";
        }
        echo "</ul>";
    } else {
        echo "<p style='color: red;'>Keine LGS_ID-Einträge gefunden!</p>";
    }
    
} else {
    echo "<p style='color: red;'>HTML-Datei nicht gefunden: $htmlFile</p>";
}
?>
