<?php
/**
 * Debug-Test für resy_image_proxy.php
 */

// Simuliere GET-Parameter
$_GET['lgfoto_id'] = '75767';
$_GET['appointment_id'] = '89'; // Test appointment ID

echo "<h1>Debug Test für resy_image_proxy.php</h1>";

echo "<h2>GET Parameter:</h2>";
echo "<pre>";
print_r($_GET);
echo "</pre>";

echo "<h2>Test URL:</h2>";
$testUrl = "http://100.82.207.72:8080/api/resy_image_proxy.php?lgfoto_id=75767&appointment_id=89";
echo "<a href='$testUrl' target='_blank'>$testUrl</a>";

echo "<h2>Test mit cURL:</h2>";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $testUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_NOBODY, true);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "<p>HTTP Code: $httpCode</p>";
echo "<p>Response Headers:</p>";
echo "<pre>" . htmlspecialchars($response) . "</pre>";

echo "<h2>Log-Datei prüfen:</h2>";
$logFile = __DIR__ . '/logs/resy_image_proxy.log';
if (file_exists($logFile)) {
    echo "<p>Log-Datei gefunden: $logFile</p>";
    $logContent = file_get_contents($logFile);
    $lines = explode("\n", $logContent);
    $recentLines = array_slice($lines, -20); // Letzte 20 Zeilen
    echo "<pre>" . htmlspecialchars(implode("\n", $recentLines)) . "</pre>";
} else {
    echo "<p>Log-Datei nicht gefunden: $logFile</p>";
}

echo "<h2>Datenbankverbindung testen:</h2>";
try {
    require_once __DIR__ . '/config/database.php';
    $db = new Database();
    $conn = $db->getConnection();
    
    // Teste Autohaus-Abfrage
    $stmt = $conn->prepare("
        SELECT a.resy_base_url, a.resy_username, a.resy_password 
        FROM autohaus a 
        JOIN appointments ap ON a.id = ap.autohaus_id 
        WHERE ap.id = ?
    ");
    $stmt->execute([89]);
    $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($autohaus) {
        echo "<p>Autohaus gefunden:</p>";
        echo "<pre>" . print_r($autohaus, true) . "</pre>";
    } else {
        echo "<p>Kein Autohaus für Appointment ID 89 gefunden</p>";
    }
    
} catch (Exception $e) {
    echo "<p>Datenbankfehler: " . $e->getMessage() . "</p>";
}

echo "<h2>Session-Info:</h2>";
session_start();
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

echo "<h2>Server-Info:</h2>";
echo "<p>Referer: " . ($_SERVER['HTTP_REFERER'] ?? 'Nicht gesetzt') . "</p>";
echo "<p>User Agent: " . ($_SERVER['HTTP_USER_AGENT'] ?? 'Nicht gesetzt') . "</p>";
?>
