<?php
echo "=== TESTING API VIA HTTP ===\n";

$url = 'http://172.24.10.114:8080/api/check_tire_status.php';
$data = [
    'storage_number' => '9.716.991',
    'appointment_date' => '',
    'event_name' => 'Test'
];

$options = [
    'http' => [
        'header' => "Content-Type: application/json\r\n",
        'method' => 'POST',
        'content' => json_encode($data)
    ]
];

$context = stream_context_create($options);
$result = file_get_contents($url, false, $context);

echo "=== RAW RESPONSE ===\n";
echo "Length: " . strlen($result) . "\n";
echo "First 500 chars: " . substr($result, 0, 500) . "\n";
echo "Last 500 chars: " . substr($result, -500) . "\n";

echo "\n=== JSON PARSE TEST ===\n";
$parsed = json_decode($result, true);

if (json_last_error() === JSON_ERROR_NONE) {
    echo "JSON PARSING SUCCESS\n";
    echo "Success: " . ($parsed['success'] ? 'true' : 'false') . "\n";
    if (isset($parsed['data']['reifen_vl'])) {
        echo "Reifen VL: " . $parsed['data']['reifen_vl']['volltext'] . "\n";
    }
} else {
    echo "JSON PARSING ERROR: " . json_last_error_msg() . "\n";
    echo "Error at position: " . json_last_error() . "\n";
}
?>
