<?php
/**
 * HTML-Analyse für RESY-Detailseite
 */

echo "<h1>HTML-Analyse für RESY-Detailseite</h1>";

// Simuliere den direkten Aufruf der Detailseite
$lgsId = '9718476';
$baseUrl = 'https://resy.dtm-reifen.de';
$detailUrl = $baseUrl . "/index.php?m=wheelset&a=edit&LGS_ID=$lgsId&FN=WheelsetResult";

echo "<h2>URL:</h2>";
echo "<p><strong>$detailUrl</strong></p>";

echo "<h2>HTML-Inhalt:</h2>";

// HTTP-Request
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $detailUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "<p style='color: red;'>cURL Error: $error</p>";
} else {
    echo "<p>HTTP Code: $httpCode</p>";
    echo "<p>Response Length: " . strlen($response) . " bytes</p>";
    
    if ($httpCode === 200) {
        // HTML analysieren
        $dom = new DOMDocument();
        @$dom->loadHTML($response);
        $xpath = new DOMXPath($dom);
        
        echo "<h3>Alle Elemente mit IDs:</h3>";
        $elements = $xpath->query("//*[@id]");
        echo "<p>Gefundene Elemente mit IDs: " . $elements->length . "</p>";
        
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr><th>ID</th><th>Tag</th><th>Inhalt (erste 100 Zeichen)</th></tr>";
        
        $wheelElements = [];
        foreach ($elements as $element) {
            $id = $element->getAttribute('id');
            $tagName = $element->tagName;
            $content = trim($element->textContent);
            $content = substr($content, 0, 100);
            
            if (strpos($id, 'Wheel') !== false || strpos($id, 'wheel') !== false) {
                $wheelElements[] = $id;
                echo "<tr style='background-color: #ffffcc;'>";
            } else {
                echo "<tr>";
            }
            
            echo "<td>$id</td>";
            echo "<td>$tagName</td>";
            echo "<td>" . htmlspecialchars($content) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        echo "<h3>Wheel-Elemente (relevant für unsere Extraktion):</h3>";
        if (!empty($wheelElements)) {
            echo "<ul>";
            foreach ($wheelElements as $id) {
                $element = $xpath->query("//*[@id='$id']")->item(0);
                if ($element) {
                    $content = trim($element->textContent);
                    echo "<li><strong>$id</strong>: " . htmlspecialchars($content) . "</li>";
                }
            }
            echo "</ul>";
        } else {
            echo "<p style='color: red;'>Keine Wheel-Elemente gefunden!</p>";
        }
        
        // Suche nach spezifischen Elementen aus dem Beispiel
        echo "<h3>Suche nach spezifischen Elementen:</h3>";
        $specificElements = [
            'WheelHALTERNAME' => 'Fahrzeughalter',
            'WheelKENNZEICHEN' => 'Kennzeichen',
            'WheelFAHRGESTNR' => 'FIN',
            'WheelLGS_ID' => 'Eingangsnummer',
            'wheelsRUECK.LADESTELLE' => 'Ladestelle',
            'WheelRUECKLIEFERTERMIN' => 'Rücklieferungsdatum',
            'WheelRUECKAKTBEMERKUNG' => 'Rückgabe Bemerkung'
        ];
        
        foreach ($specificElements as $id => $description) {
            $element = $xpath->query("//*[@id='$id']")->item(0);
            if ($element) {
                $content = trim($element->textContent);
                echo "<p><strong>$description ($id)</strong>: " . htmlspecialchars($content) . "</p>";
            } else {
                echo "<p style='color: red;'><strong>$description ($id)</strong>: Nicht gefunden!</p>";
            }
        }
        
        // Suche nach Bemerkung textarea
        echo "<h3>Bemerkung textarea:</h3>";
        $textarea = $xpath->query("//textarea[@name='KDBEMERK']")->item(0);
        if ($textarea) {
            $content = trim($textarea->textContent);
            echo "<p><strong>Bemerkung (textarea)</strong>: " . htmlspecialchars($content) . "</p>";
        } else {
            echo "<p style='color: red;'><strong>Bemerkung (textarea)</strong>: Nicht gefunden!</p>";
        }
        
    } else {
        echo "<p style='color: red;'>HTTP Error: $httpCode</p>";
    }
}
?>
