<?php
echo "=== TESTING BOTH STORAGE NUMBERS ===\n\n";

$url = 'http://172.24.10.114:8080/api/check_tire_status_simple.php';

$testCases = [
    '9.716.991' => 'Pirelli Scorpion Winter (leichte_fehler)',
    '9.718.498' => 'Michelin Pilot Sport 4 (gut)'
];

foreach ($testCases as $storageNumber => $expected) {
    echo "--- Testing Storage Number: {$storageNumber} ---\n";
    echo "Expected: {$expected}\n";
    
    $data = ['storage_number' => $storageNumber];
    
    $options = [
        'http' => [
            'header' => "Content-Type: application/json\r\n",
            'method' => 'POST',
            'content' => json_encode($data),
            'ignore_errors' => true,
            'timeout' => 30
        ]
    ];
    
    $context = stream_context_create($options);
    $result = file_get_contents($url, false, $context);
    
    if (strlen($result) > 0) {
        $parsed = json_decode($result, true);
        if (json_last_error() === JSON_ERROR_NONE && $parsed['success']) {
            echo "✅ Success: " . $parsed['data']['einlagerungsnummer'] . "\n";
            echo "✅ Haltername: " . $parsed['data']['haltername'] . "\n";
            echo "✅ Reifen VL: " . $parsed['data']['reifen_vl']['volltext'] . "\n";
            echo "✅ Reifen VL Zustand: " . $parsed['data']['reifen_vl']['zustand'] . "\n";
            echo "✅ Reifen Art: " . $parsed['data']['reifen_vl']['art'] . "\n";
            echo "✅ Luftdruck: " . $parsed['data']['reifen_vl']['luftdruck'] . "\n";
            echo "✅ Profiltiefe I: " . $parsed['data']['reifen_vl']['profiltiefe']['i'] . "mm\n";
            echo "✅ Empfehlung: " . $parsed['data']['reifen_vl']['empfehlung'] . "\n";
        } else {
            echo "❌ Error: " . ($parsed['error'] ?? 'Unknown error') . "\n";
        }
    } else {
        echo "❌ No response\n";
    }
    
    echo "\n";
}
?>
