<?php
// CLI only
if (php_sapi_name() !== 'cli') { echo "CLI only\n"; exit(1); }

$api_key = '306426e96ccc208c97ff49dc51d85558';
$base_url = 'http://localhost/boxenstop';

$endpoints = [
    // Diese sollten via Guard mit API-Key funktionieren
    '/api/get_available_slots.php?event_id=21&date=2025-10-31' => 'GET',
    '/api/settings.php' => 'GET',
    '/api/appointments.php?event_id=21&date=2025-10-31' => 'GET',
    
    // Diese geben ohne Session 401/403
    '/api/get_user_profile.php' => 'GET',
    '/api/get_vehicle.php?id=1' => 'GET',
    '/api/get_user_notifications.php' => 'GET',
    '/api/get_activity_log.php' => 'GET',
    '/api/update_profile.php' => 'POST',
    '/api/cancel_appointment.php' => 'POST',
    
    // Tire/Offer APIs
    '/api/get_autohauser.php' => 'GET',
    '/api/get_autohaus_services.php?autohaus_id=1' => 'GET',
    '/api/get_offer_details.php?appointmentId=1' => 'GET',
    '/api/get_customer_selection.php?appointmentId=1' => 'GET',
];

echo "API-Key Monitoring Coverage Test\n";
echo "====================================\n\n";

foreach ($endpoints as $endpoint => $method) {
    $url = $base_url . $endpoint;
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => ['Content-Type: application/json', "X-Api-Key: {$api_key}"],
        CURLOPT_CUSTOMREQUEST => $method,
    ]);
    curl_exec($ch);
    curl_close($ch);
    usleep(50000); // 50ms Pause
}

echo "✅ Alle Endpunkte aufgerufen!\n";
echo "→ Jetzt im Browser öffnen: admin/api_manager.php → Monitoring prüfen\n";
?>

