<?php
// CLI only
if (php_sapi_name() !== 'cli') { echo "CLI only\n"; exit(1); }

$api_key = '306426e96ccc208c97ff49dc51d85558';
$base_url = 'http://localhost/boxenstop';

// Alle API-Dateien aus dem api/ Ordner (ohne Guard/Hilfsdateien)
$api_files = [
    // Public / Settings
    'settings.php' => ['method' => 'GET', 'params' => []],

    // Slots & Appointments
    'get_available_slots.php' => ['method' => 'GET', 'params' => ['event_id' => 21, 'date' => '2025-10-31']],
    
    // Diese würden ohne Session 401 geben (test trotzdem für Tracking)
    'get_user_profile.php' => ['method' => 'GET', 'params' => [], 'expect' => [401, 403]],
    'get_vehicle.php' => ['method' => 'GET', 'params' => ['id' => 1], 'expect' => [400, 401, 403]],
    'get_user_notifications.php' => ['method' => 'GET', 'params' => [], 'expect' => [401, 403]],
    'get_activity_log.php' => ['method' => 'GET', 'params' => [], 'expect' => [401, 403]],
];

echo "API-Key Test – Komplette Abdeckung\n";
echo "API Key: {$api_key}\n";
echo "====================================\n\n";

$results = [];

foreach ($api_files as $file => $config) {
    $method = $config['method'];
    $params = $config['params'] ?? [];
    $expect = $config['expect'] ?? [200, 400, 401, 403];
    
    $url = $base_url . '/api/' . $file;
    if ($method === 'GET' && !empty($params)) {
        $url .= '?' . http_build_query($params);
    }
    
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => ['Content-Type: application/json', "X-Api-Key: {$api_key}"],
        CURLOPT_CUSTOMREQUEST => $method,
    ]);
    
    $response = curl_exec($ch);
    $status = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
    curl_close($ch);
    
    $passed = in_array($status, $expect, true);
    $results[] = ['file' => $file, 'status' => $status, 'passed' => $passed, 'expect' => $expect];
    
    $icon = $passed ? '✅' : '⚠️';
    echo "{$icon} {$method} /api/{$file}\n";
    echo "   Status: {$status}\n";
    
    $json = json_decode($response, true);
    if ($json && isset($json['message'])) {
        echo "   Message: " . substr($json['message'], 0, 60) . "...\n";
    }
    echo "\n";
}

echo "\n====================================\n";
echo "Ergebnis: " . count(array_filter($results, fn($r) => $r['passed'])) . " von " . count($results) . " Tests erfolgreich\n";

// Zeige DB-Logs
echo "\n--- DB Usage Logs (nachverfolgen) ---\n";
require_once __DIR__ . '/../config/database.php';
try {
    $db = new Database();
    $conn = $db->getConnection();
    $stmt = $conn->query("SELECT endpoint, http_method, status_code, request_ts FROM api_key_usage ORDER BY id DESC LIMIT 5");
    $logs = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($logs as $log) {
        echo sprintf("%s %s → %s @ %s\n", $log['http_method'], $log['endpoint'], $log['status_code'], $log['request_ts']);
    }
} catch (Throwable $e) {
    echo "Fehler beim Abrufen der Logs: " . $e->getMessage() . "\n";
}
?>

