<?php
/**
 * Test mit der funktionierenden LGS_ID 9716706 und verbesserter Session-Verwaltung
 */

require_once 'api/resy_data_extraction_breakthrough.php';

echo "=== TEST MIT FUNKTIONIERENDER LGS_ID UND VERBESSERTER SESSION ===\n";

$testConfig = [
    'base_url' => 'https://resy.dtm-reifen.de',
    'username' => 'D.ULUDAG',
    'password' => 'Ikizler123!',
    'working_lgs_id' => '9716706'  // Diese LGS_ID haben Sie als funktionierend gezeigt
];

echo "Base URL: " . $testConfig['base_url'] . "\n";
echo "Working LGS_ID: " . $testConfig['working_lgs_id'] . "\n";
echo "Erwartete URL: " . $testConfig['base_url'] . "/resyweb/index.php?m=wheelset&a=edit&LGS_ID=" . $testConfig['working_lgs_id'] . "&FN=WheelsetResult\n\n";

try {
    // Verwende die gleiche cURL-Instanz für Login und Suche
    $ch = curl_init();
    $cookieFile = sys_get_temp_dir() . '/resy_test_session.txt';
    
    // Lösche alte Cookie-Datei
    if (file_exists($cookieFile)) {
        unlink($cookieFile);
    }
    
    echo "--- Schritt 1: Login durchführen ---\n";
    $loginUrl = $testConfig['base_url'] . '/index.php?m=login&a=login';
    
    // Lade Login-Seite
    curl_setopt($ch, CURLOPT_URL, $loginUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);
    curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
        'Accept-Language: de-DE,de;q=0.9,en;q=0.8',
        'Connection: keep-alive',
        'Upgrade-Insecure-Requests: 1'
    ]);
    
    $loginPageResponse = curl_exec($ch);
    $loginPageCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    echo "Login-Seite geladen: HTTP $loginPageCode\n";
    
    // Login-Daten senden
    $postData = [
        'FN' => 'login',
        'UserName' => $testConfig['username'],
        'Password' => $testConfig['password'],
        'button' => 'submit'
    ];
    
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded',
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
        'Accept-Language: de-DE,de;q=0.9,en;q=0.8',
        'Connection: keep-alive',
        'Upgrade-Insecure-Requests: 1',
        'Referer: ' . $loginUrl
    ]);
    
    $loginResponse = curl_exec($ch);
    $loginCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $loginFinalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
    echo "Login-Response: HTTP $loginCode, Final URL: $loginFinalUrl\n";
    
    // Prüfe Login-Erfolg
    $isLoginPage = strpos($loginResponse, 'Anmeldename') !== false;
    if ($isLoginPage) {
        curl_close($ch);
        throw new Exception("Login fehlgeschlagen");
    }
    echo "✅ Login erfolgreich!\n\n";
    
    echo "--- Schritt 2: Teste direkte LGS_ID-URL ---\n";
    $directUrl = $testConfig['base_url'] . '/resyweb/index.php?m=wheelset&a=edit&LGS_ID=' . $testConfig['working_lgs_id'] . '&FN=WheelsetResult';
    echo "Direkte URL: $directUrl\n";
    
    curl_setopt($ch, CURLOPT_POST, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, null);
    curl_setopt($ch, CURLOPT_URL, $directUrl);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
        'Accept-Language: de-DE,de;q=0.9,en;q=0.8',
        'Connection: keep-alive',
        'Upgrade-Insecure-Requests: 1',
        'Referer: ' . $loginFinalUrl
    ]);
    
    $directResponse = curl_exec($ch);
    $directCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $directFinalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
    
    echo "Response Code: $directCode\n";
    echo "Final URL: $directFinalUrl\n";
    echo "Content Length: " . strlen($directResponse) . " Zeichen\n";
    
    // Speichere die Antwort
    file_put_contents(sys_get_temp_dir() . "/resy_working_lgs_test.html", $directResponse);
    echo "Antwort gespeichert in: " . sys_get_temp_dir() . "/resy_working_lgs_test.html\n";
    
    // Analysiere den Inhalt
    $hasLoginForm = strpos($directResponse, 'Anmeldename') !== false;
    $hasWheelsetData = strpos($directResponse, 'WheelHALTERNAME') !== false || 
                      strpos($directResponse, 'WheelKENNZEICHEN') !== false ||
                      strpos($directResponse, 'WheelFAHRGESTNR') !== false;
    $hasLgsId = strpos($directResponse, 'LGS_ID') !== false;
    $hasTargetLgsId = strpos($directResponse, $testConfig['working_lgs_id']) !== false;
    
    echo "Enthält Login-Form: " . ($hasLoginForm ? 'Ja' : 'Nein') . "\n";
    echo "Enthält Wheelset-Daten: " . ($hasWheelsetData ? 'Ja' : 'Nein') . "\n";
    echo "Enthält LGS_ID: " . ($hasLgsId ? 'Ja' : 'Nein') . "\n";
    echo "Enthält Ziel-LGS_ID (" . $testConfig['working_lgs_id'] . "): " . ($hasTargetLgsId ? 'Ja' : 'Nein') . "\n";
    
    if ($hasWheelsetData && $hasTargetLgsId) {
        echo "🎉 ERFOLG! Funktionierende LGS_ID mit Wheelset-Daten gefunden!\n";
        
        // Extrahiere einige Daten zur Bestätigung
        if (preg_match('/WheelHALTERNAME[^>]*>([^<]+)/', $directResponse, $matches)) {
            echo "Fahrzeughalter: " . trim($matches[1]) . "\n";
        }
        if (preg_match('/WheelKENNZEICHEN[^>]*>([^<]+)/', $directResponse, $matches)) {
            echo "Kennzeichen: " . trim($matches[1]) . "\n";
        }
        
    } elseif ($hasLoginForm) {
        echo "❌ Session verloren - zur Login-Seite umgeleitet\n";
    } else {
        echo "⚠️ Andere Antwort - Details in der gespeicherten HTML-Datei\n";
    }
    
    curl_close($ch);
    
} catch (Exception $e) {
    echo "❌ Test fehlgeschlagen: " . $e->getMessage() . "\n";
}

echo "\n=== TEST ABGESCHLOSSEN ===\n";
?>
