<?php
/**
 * Test der aktualisierten RESY-API mit neuer URL-Struktur
 */

require_once 'api/resy_data_extraction_breakthrough.php';

echo "=== TEST AKTUALISIERTE RESY-API MIT NEUER URL-STRUKTUR ===\n";

$testConfig = [
    'base_url' => 'https://resy.dtm-reifen.de',
    'test_lgs_id' => '9877038'
];

echo "Base URL: " . $testConfig['base_url'] . "\n";
echo "Test LGS_ID: " . $testConfig['test_lgs_id'] . "\n";
echo "Neue URL-Struktur: /resyweb/index.php?m=wheelset&a=edit&LGS_ID={LGS_ID}&FN=WheelsetResult\n\n";

try {
    echo "--- Teste neue Suchfunktion mit aktualisierter URL-Struktur ---\n";
    
    $searchResult = searchWithWorkingLgsIds($testConfig['base_url'], $testConfig['test_lgs_id']);
    
    echo "✅ Suche erfolgreich!\n";
    echo "Gefundene LGS_ID: " . $searchResult['lgs_id'] . "\n";
    echo "Suchmethode: " . ($searchResult['search_method'] ?? $searchResult['search_type'] ?? 'unbekannt') . "\n";
    echo "Nachricht: " . $searchResult['message'] . "\n";
    
    // Prüfe die Antwort
    if (isset($searchResult['response']['body'])) {
        $responseBody = $searchResult['response']['body'];
        echo "Response Code: " . $searchResult['response']['http_code'] . "\n";
        echo "Content Length: " . strlen($responseBody) . " Zeichen\n";
        
        // Prüfe ob es echte Wheelset-Daten sind
        $hasWheelData = strpos($responseBody, 'WheelHALTERNAME') !== false ||
                        strpos($responseBody, 'WheelKENNZEICHEN') !== false ||
                        strpos($responseBody, 'WheelFAHRGESTNR') !== false;
        
        if ($hasWheelData) {
            echo "✅ Echte Wheelset-Daten gefunden!\n";
            
            // Extrahiere einige Daten
            try {
                $vehicleData = [];
                $fields = ['fahrzeughalter', 'kennzeichen', 'fin'];
                foreach ($fields as $field) {
                    $value = extractDataFromHtml($responseBody, $field);
                    $vehicleData[$field] = $value;
                    echo "  $field: $value\n";
                }
            } catch (Exception $e) {
                echo "⚠️ Fehler beim Extrahieren der Fahrzeugdaten: " . $e->getMessage() . "\n";
            }
        } else {
            echo "❌ Keine echten Wheelset-Daten gefunden\n";
        }
    }
    
} catch (Exception $e) {
    echo "❌ Test fehlgeschlagen: " . $e->getMessage() . "\n";
    
    // Zeige detaillierte Fehlerinformationen
    echo "\n--- DETAILLIERTE FEHLERINFORMATIONEN ---\n";
    echo "Fehler: " . $e->getMessage() . "\n";
    echo "Datei: " . $e->getFile() . "\n";
    echo "Zeile: " . $e->getLine() . "\n";
    
    // Prüfe die Logs
    $logFile = 'logs/resy_extraction.log';
    if (file_exists($logFile)) {
        echo "\n--- LETZTE LOG-EINTRÄGE ---\n";
        $logs = file($logFile);
        $lastLogs = array_slice($logs, -15);
        foreach ($lastLogs as $log) {
            echo trim($log) . "\n";
        }
    }
}

echo "\n=== TEST ABGESCHLOSSEN ===\n";
echo "Prüfen Sie die Logs in: logs/resy_extraction.log\n";
echo "Prüfen Sie die HTML-Dateien in: " . sys_get_temp_dir() . "/\n";
?>
