<?php
/**
 * Test RESY mit Selenium
 */

require_once 'api/resy_selenium_simple.php';

echo "🔍 RESY Selenium Test\n";
echo "===================\n\n";

$driver = new ResySeleniumDriver('D.ULUDAG', 'Ikizler123!', '453');

// Prüfe Verbindung
if (ResySeleniumDriver::isAvailable()) {
    echo "✅ Selenium ist verfügbar\n\n";
} else {
    echo "❌ Selenium ist NICHT verfügbar!\n";
    echo "Bitte prüfen: docker-compose ps\n";
    exit(1);
}

// Teste Login
echo "🧪 Teste Login...\n";
if ($driver->login()) {
    echo "✅ Login erfolgreich!\n\n";
    
    echo "🧪 Lade Reifensätze...\n";
    $html = $driver->loadWheelsets();
    
    if ($html && strlen($html) > 100) {
        echo "✅ Reifensätze geladen: " . strlen($html) . " Zeichen\n";
        
        // Speichere HTML zur Analyse
        file_put_contents('temp/resy_selenium_result.html', $html);
        echo "📄 HTML gespeichert in: temp/resy_selenium_result.html\n";
    } else {
        echo "❌ Keine Daten geladen\n";
    }
} else {
    echo "❌ Login fehlgeschlagen\n";
}

$driver->close();

echo "\n✅ Test abgeschlossen!\n";

?>

