# Test Selenium mit PowerShell

Write-Host "🧪 Teste Selenium-Session-Creation..." -ForegroundColor Cyan

# 1. Status prüfen
Write-Host "`n[1/3] Prüfe Selenium-Status..." -ForegroundColor Yellow
$status = Invoke-RestMethod -Uri "http://localhost:4444/wd/hub/status" -Method Get
Write-Host "✅ Selenium bereit: $($status.value.ready)" -ForegroundColor Green

# 2. Session erstellen
Write-Host "`n[2/3] Erstelle Selenium-Session..." -ForegroundColor Yellow

$body = @{
    capabilities = @{
        alwaysMatch = @{
            browserName          = "chrome"
            "goog:chromeOptions" = @{
                args = @("--no-sandbox", "--disable-dev-shm-usage")
            }
        }
    }
} | ConvertTo-Json -Depth 10

try {
    $headers = @{
        "Content-Type" = "application/json"
    }
    
    $response = Invoke-RestMethod -Uri "http://localhost:4444/wd/hub/session" `
        -Method Post `
        -Body $body `
        -Headers $headers `
        -ErrorAction Stop
    
    $sessionId = $response.value.sessionId
    Write-Host "✅ Session erstellt: $sessionId" -ForegroundColor Green
    
    # 3. Navigiere zur Login-Seite
    Write-Host "`n[3/3] Navigiere zur RESY-Login-Seite..." -ForegroundColor Yellow
    
    $navBody = @{
        url = "https://resy.dtm-reifen.de/index.php?m=login&a=login"
    } | ConvertTo-Json
    
    $navResponse = Invoke-RestMethod -Uri "http://localhost:4444/wd/hub/session/$sessionId/url" `
        -Method Post `
        -Body $navBody `
        -Headers $headers `
        -ErrorAction Stop
    
    Write-Host "✅ Navigation erfolgreich!" -ForegroundColor Green
    
    # Page title holen
    $titleResponse = Invoke-RestMethod -Uri "http://localhost:4444/wd/hub/session/$sessionId/title" `
        -Method Get
    
    Write-Host "📄 Page Title: $($titleResponse.value)" -ForegroundColor Cyan
    
    # Session beenden
    Write-Host "`n🔚 Beende Session..." -ForegroundColor Yellow
    Invoke-RestMethod -Uri "http://localhost:4444/wd/hub/session/$sessionId" `
        -Method Delete
    
    Write-Host "`n✅ ALLES FUNKTIONIERT!" -ForegroundColor Green
    
}
catch {
    Write-Host "❌ FEHLER: $($_.Exception.Message)" -ForegroundColor Red
    Write-Host $_.Exception
}

Write-Host "`nTest abgeschlossen!" -ForegroundColor Cyan

