// Node.js Test für Selenium
const https = require('http');

console.log('🧪 Teste Selenium-Session...\n');

// 1. Status prüfen
console.log('[1/4] Prüfe Selenium-Status...');
https.get('http://localhost:4444/wd/hub/status', (res) => {
    let data = '';
    res.on('data', chunk => data += chunk);
    res.on('end', () => {
        const status = JSON.parse(data);
        console.log('✅ Selenium bereit:', status.value.ready);
        
        // 2. Session erstellen
        console.log('\n[2/4] Erstelle Session...');
        createSession();
    });
});

function createSession() {
    const body = JSON.stringify({
        capabilities: {
            alwaysMatch: {
                browserName: 'chrome',
                'goog:chromeOptions': {
                    args: ['--no-sandbox', '--disable-dev-shm-usage']
                }
            }
        }
    });
    
    const options = {
        hostname: 'localhost',
        port: 4444,
        path: '/wd/hub/session',
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Content-Length': body.length
        }
    };
    
    const req = https.request(options, (res) => {
        let data = '';
        res.on('data', chunk => data += chunk);
        res.on('end', () => {
            if (res.statusCode === 200) {
                const response = JSON.parse(data);
                const sessionId = response.value.sessionId;
                console.log('✅ Session erstellt:', sessionId);
                console.log('\n[3/4] Navigiere zur Login-Seite...');
                navigateToLogin(sessionId);
            } else {
                console.log('❌ Fehler:', res.statusCode);
                console.log(data);
            }
        });
    });
    
    req.on('error', (e) => {
        console.error('❌ Request-Fehler:', e.message);
    });
    
    req.write(body);
    req.end();
}

function navigateToLogin(sessionId) {
    const body = JSON.stringify({
        url: 'https://resy.dtm-reifen.de/index.php?m=login&a=login'
    });
    
    const options = {
        hostname: 'localhost',
        port: 4444,
        path: `/wd/hub/session/${sessionId}/url`,
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Content-Length': body.length
        }
    };
    
    const req = https.request(options, (res) => {
        let data = '';
        res.on('data', chunk => data += chunk);
        res.on('end', () => {
            if (res.statusCode === 200) {
                console.log('✅ Navigation erfolgreich!');
                console.log('\n[4/4] Hole Page-Title...');
                getTitle(sessionId);
            } else {
                console.log('❌ Navigation fehlgeschlagen:', res.statusCode);
                console.log(data);
            }
        });
    });
    
    req.on('error', (e) => {
        console.error('❌ Request-Fehler:', e.message);
    });
    
    req.write(body);
    req.end();
}

function getTitle(sessionId) {
    const options = {
        hostname: 'localhost',
        port: 4444,
        path: `/wd/hub/session/${sessionId}/title`,
        method: 'GET'
    };
    
    const req = https.request(options, (res) => {
        let data = '';
        res.on('data', chunk => data += chunk);
        res.on('end', () => {
            if (res.statusCode === 200) {
                const response = JSON.parse(data);
                console.log('📄 Page-Title:', response.value);
                
                // Session beenden
                console.log('\n🔚 Beende Session...');
                deleteSession(sessionId);
            } else {
                console.log('❌ Fehler beim Abrufen des Titles');
            }
        });
    });
    
    req.on('error', (e) => {
        console.error('❌ Fehler:', e.message);
    });
    
    req.end();
}

function deleteSession(sessionId) {
    const options = {
        hostname: 'localhost',
        port: 4444,
        path: `/wd/hub/session/${sessionId}`,
        method: 'DELETE'
    };
    
    const req = https.request(options, (res) => {
        console.log('✅ Session beendet');
        console.log('\n✅ ALLES FUNKTIONIERT!');
    });
    
    req.on('error', (e) => {
        console.error('❌ Fehler:', e.message);
    });
    
    req.end();
}

